/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.message;

import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.message.MessageType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;

public abstract class TypedMessage
extends Message {
    private final String text;

    public TypedMessage(MessageType type, String text) {
        super(TypedMessage.getPayloadByteBuffer(type, text).array(), type);
        Validate.notNull((Object)text, (String)"text is required", (Object[])new Object[0]);
        this.text = text;
    }

    public static ByteBuffer getPayloadByteBuffer(MessageType type, String text) {
        byte byteMessageType = (byte)type.getValue();
        byte[] bytePayload = text.getBytes(StandardCharsets.UTF_8);
        ByteBuffer messageBuffer = ByteBuffer.allocate(bytePayload.length + 1);
        messageBuffer.put(byteMessageType);
        messageBuffer.put(bytePayload);
        return messageBuffer;
    }

    @Override
    public String getText() {
        return this.text;
    }
}

