/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.message;

import io.nem.symbol.core.crypto.BlockCipher;
import io.nem.symbol.core.crypto.CryptoEngine;
import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.KeyPair;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.utils.ArrayUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.message.Message;
import io.nem.symbol.sdk.model.message.MessageType;
import org.apache.commons.lang3.Validate;

public class PersistentHarvestingDelegationMessage
extends Message {
    public static final int HEX_PAYLOAD_SIZE = 264;

    public PersistentHarvestingDelegationMessage(String payload) {
        super(ConvertUtils.fromHexToBytes(payload), MessageType.PERSISTENT_HARVESTING_DELEGATION_MESSAGE);
        Validate.isTrue((payload.length() == 264 ? 1 : 0) != 0, (String)"Invalid delegate message payload size", (Object[])new Object[0]);
        Validate.isTrue((boolean)payload.toUpperCase().startsWith("FE2A8061577301E2"), (String)"Invalid delegate message payload prefixed mark", (Object[])new Object[0]);
    }

    public static PersistentHarvestingDelegationMessage create(PrivateKey signingPrivateKey, PrivateKey vrfPrivateKey, PublicKey nodePublicKey) {
        KeyPair ephemeralKeyPair = KeyPair.random();
        CryptoEngine engine = CryptoEngines.defaultEngine();
        KeyPair recipient = KeyPair.onlyPublic(nodePublicKey, engine);
        BlockCipher blockCipher = engine.createBlockCipher(ephemeralKeyPair, recipient);
        byte[] encrypted = blockCipher.encrypt(ArrayUtils.concat(signingPrivateKey.getBytes(), vrfPrivateKey.getBytes()));
        String encryptedHex = ConvertUtils.toHex(encrypted);
        String payload = "FE2A8061577301E2" + ephemeralKeyPair.getPublicKey().toHex() + encryptedHex;
        return new PersistentHarvestingDelegationMessage(payload.toUpperCase());
    }

    public HarvestingKeys decryptPayload(PrivateKey recipientPrivateKey) {
        int markerLength = "FE2A8061577301E2".length();
        int publicKeyHexSize = 64;
        PublicKey senderPublicKey = PublicKey.fromHexString(this.getText().substring(markerLength, markerLength + publicKeyHexSize));
        String encryptedPayload = this.getText().substring(markerLength + publicKeyHexSize);
        CryptoEngine engine = CryptoEngines.defaultEngine();
        KeyPair sender = KeyPair.onlyPublic(senderPublicKey, engine);
        KeyPair recipient = KeyPair.fromPrivate(recipientPrivateKey);
        BlockCipher blockCipher = engine.createBlockCipher(sender, recipient);
        byte[] decryptPayload = blockCipher.decrypt(ConvertUtils.fromHexToBytes(encryptedPayload));
        String doubleKey = ConvertUtils.toHex(decryptPayload);
        PrivateKey signingPrivateKey = PrivateKey.fromHexString(doubleKey.substring(0, publicKeyHexSize));
        PrivateKey vrfPrivateKey = PrivateKey.fromHexString(doubleKey.substring(publicKeyHexSize));
        return new HarvestingKeys(signingPrivateKey, vrfPrivateKey);
    }

    @Override
    public String getText() {
        return this.getPayloadHex();
    }

    public static class HarvestingKeys {
        private final PrivateKey signingPrivateKey;
        private final PrivateKey vrfPrivateKey;

        private HarvestingKeys(PrivateKey signingPrivateKey, PrivateKey vrfPrivateKey) {
            Validate.notNull((Object)signingPrivateKey, (String)"signingPrivateKey is required", (Object[])new Object[0]);
            Validate.notNull((Object)vrfPrivateKey, (String)"vrfPrivateKey is required", (Object[])new Object[0]);
            this.signingPrivateKey = signingPrivateKey;
            this.vrfPrivateKey = vrfPrivateKey;
        }

        public PrivateKey getSigningPrivateKey() {
            return this.signingPrivateKey;
        }

        public PrivateKey getVrfPrivateKey() {
            return this.vrfPrivateKey;
        }
    }
}

