/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.message;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.message.EncryptedMessage;
import io.nem.symbol.sdk.model.message.MessageType;
import io.nem.symbol.sdk.model.message.PersistentHarvestingDelegationMessage;
import io.nem.symbol.sdk.model.message.PlainMessage;
import io.nem.symbol.sdk.model.message.RawMessage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public abstract class Message {
    private final byte[] payload;
    private final MessageType type;

    public Message(byte[] payload, MessageType type) {
        Validate.notNull((Object)payload, (String)"payload is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)type), (String)"type is required", (Object[])new Object[0]);
        this.payload = payload;
        this.type = type;
    }

    public static Optional<Message> createFromPayload(byte[] payload) {
        if (payload == null || payload.length == 0) {
            return Optional.empty();
        }
        return Message.createFromHexPayload(ConvertUtils.toHex(payload));
    }

    public static Optional<Message> createFromHexPayload(String payloadHex) {
        if (payloadHex == null || payloadHex.isEmpty()) {
            return Optional.empty();
        }
        String upperCasePayload = payloadHex.toUpperCase();
        if (upperCasePayload.length() == 264 && upperCasePayload.startsWith("FE2A8061577301E2")) {
            return Optional.of(new PersistentHarvestingDelegationMessage(upperCasePayload));
        }
        byte[] payload = ConvertUtils.fromHexToBytes(payloadHex);
        MessageType messageType = MessageType.rawValueOf(SerializationUtils.byteToUnsignedInt(payload[0]));
        String messageHex = payloadHex.substring(2);
        String text = ConvertUtils.fromHexToString(messageHex);
        switch (messageType) {
            case PLAIN_MESSAGE: {
                return Optional.of(new PlainMessage(text));
            }
            case ENCRYPTED_MESSAGE: {
                return Optional.of(new EncryptedMessage(text));
            }
        }
        return Optional.of(new RawMessage(payload));
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public MessageType getType() {
        return this.type;
    }

    public abstract String getText();

    public ByteBuffer getPayloadByteBuffer() {
        return ByteBuffer.wrap(this.getPayload());
    }

    public String getPayloadHex() {
        return ConvertUtils.toHex(this.getPayload());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Arrays.equals(this.payload, message.payload) && this.type == message.type;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type});
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }
}

