/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.message;

import io.nem.symbol.core.crypto.BlockCipher;
import io.nem.symbol.core.crypto.CryptoEngine;
import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.KeyPair;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.StringEncoder;
import io.nem.symbol.sdk.model.message.MessageType;
import io.nem.symbol.sdk.model.message.TypedMessage;

public class EncryptedMessage
extends TypedMessage {
    public EncryptedMessage(String encryptedPayload) {
        super(MessageType.ENCRYPTED_MESSAGE, encryptedPayload);
    }

    public static EncryptedMessage create(String plainTextMessage, PrivateKey senderPrivateKey, PublicKey recipientPublicKey) {
        CryptoEngine engine = CryptoEngines.defaultEngine();
        KeyPair sender = KeyPair.fromPrivate(senderPrivateKey);
        KeyPair recipient = KeyPair.onlyPublic(recipientPublicKey, engine);
        BlockCipher blockCipher = engine.createBlockCipher(sender, recipient);
        return new EncryptedMessage(ConvertUtils.toHex(blockCipher.encrypt(StringEncoder.getBytes(plainTextMessage))));
    }

    public String decryptPayload(PublicKey senderPublicKey, PrivateKey recipientPrivateKey) {
        CryptoEngine engine = CryptoEngines.defaultEngine();
        KeyPair sender = KeyPair.onlyPublic(senderPublicKey, engine);
        KeyPair recipient = KeyPair.fromPrivate(recipientPrivateKey);
        BlockCipher blockCipher = engine.createBlockCipher(sender, recipient);
        return StringEncoder.getString(blockCipher.decrypt(ConvertUtils.fromHexToBytes(this.getText())));
    }
}

