/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.blockchain;

import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.blockchain.BlockType;
import io.nem.symbol.sdk.model.network.NetworkType;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class BlockInfo
implements Stored {
    private final String recordId;
    private final Long size;
    private final String hash;
    private final String generationHash;
    private final BigInteger totalFee;
    private final List<String> stateHashSubCacheMerkleRoots;
    private final Integer transactionsCount;
    private final Integer totalTransactionsCount;
    private final Integer statementsCount;
    private final List<String> subCacheMerkleRoots;
    private final String signature;
    private final PublicAccount signerPublicAccount;
    private final NetworkType networkType;
    private final Integer version;
    private final BlockType type;
    private final BigInteger height;
    private final BigInteger timestamp;
    private final BigInteger difficulty;
    private final Long feeMultiplier;
    private final String previousBlockHash;
    private final String blockTransactionsHash;
    private final String blockReceiptsHash;
    private final String stateHash;
    private final String proofGamma;
    private final String proofScalar;
    private final String proofVerificationHash;
    private final Address beneficiaryAddress;

    public BlockInfo(String recordId, Long size, String hash, String generationHash, BigInteger totalFee, List<String> stateHashSubCacheMerkleRoots, Integer transactionsCount, Integer totalTransactionsCount, Integer statementsCount, List<String> subCacheMerkleRoots, String signature, PublicAccount signerPublicAccount, NetworkType networkType, Integer version, BlockType type, BigInteger height, BigInteger timestamp, BigInteger difficulty, Long feeMultiplier, String previousBlockHash, String blockTransactionsHash, String blockReceiptsHash, String stateHash, String proofGamma, String proofScalar, String proofVerificationHash, Address beneficiaryAddress) {
        this.recordId = recordId;
        this.size = size;
        this.hash = hash;
        this.generationHash = generationHash;
        this.totalFee = totalFee;
        this.stateHashSubCacheMerkleRoots = stateHashSubCacheMerkleRoots;
        this.transactionsCount = transactionsCount;
        this.totalTransactionsCount = totalTransactionsCount;
        this.statementsCount = statementsCount;
        this.subCacheMerkleRoots = subCacheMerkleRoots;
        this.signature = signature;
        this.signerPublicAccount = signerPublicAccount;
        this.networkType = networkType;
        this.version = version;
        this.type = type;
        this.height = height;
        this.timestamp = timestamp;
        this.difficulty = difficulty;
        this.feeMultiplier = feeMultiplier;
        this.previousBlockHash = previousBlockHash;
        this.blockTransactionsHash = blockTransactionsHash;
        this.blockReceiptsHash = blockReceiptsHash;
        this.stateHash = stateHash;
        this.proofGamma = proofGamma;
        this.proofScalar = proofScalar;
        this.proofVerificationHash = proofVerificationHash;
        this.beneficiaryAddress = beneficiaryAddress;
    }

    public Long getSize() {
        return this.size;
    }

    public String getHash() {
        return this.hash;
    }

    public String getGenerationHash() {
        return this.generationHash;
    }

    public BigInteger getTotalFee() {
        return this.totalFee;
    }

    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public Integer getStatementsCount() {
        return this.statementsCount;
    }

    public List<String> getSubCacheMerkleRoots() {
        return this.subCacheMerkleRoots;
    }

    public String getSignature() {
        return this.signature;
    }

    public PublicAccount getSignerPublicAccount() {
        return this.signerPublicAccount;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Integer getVersion() {
        return this.version;
    }

    public BlockType getType() {
        return this.type;
    }

    public BigInteger getHeight() {
        return this.height;
    }

    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public Long getFeeMultiplier() {
        return this.feeMultiplier;
    }

    public Integer getTotalTransactionsCount() {
        return this.totalTransactionsCount;
    }

    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public String getBlockTransactionsHash() {
        return this.blockTransactionsHash;
    }

    public String getBlockReceiptsHash() {
        return this.blockReceiptsHash;
    }

    public String getStateHash() {
        return this.stateHash;
    }

    public Address getBeneficiaryAddress() {
        return this.beneficiaryAddress;
    }

    public String getProofGamma() {
        return this.proofGamma;
    }

    public String getProofScalar() {
        return this.proofScalar;
    }

    public String getProofVerificationHash() {
        return this.proofVerificationHash;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public List<String> getStateHashSubCacheMerkleRoots() {
        return this.stateHashSubCacheMerkleRoots;
    }
}

