/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.network.NetworkType;
import java.util.Objects;

public class PublicAccount {
    private final Address address;
    private final PublicKey publicKey;

    public PublicAccount(String publicKey, NetworkType networkType) {
        this.address = Address.createFromPublicKey(publicKey, networkType);
        this.publicKey = PublicKey.fromHexString(publicKey);
    }

    public static PublicAccount createFromPublicKey(String publicKey, NetworkType networkType) {
        return new PublicAccount(publicKey, networkType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicAccount)) {
            return false;
        }
        PublicAccount that = (PublicAccount)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.publicKey, that.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.publicKey);
    }

    public Address getAddress() {
        return this.address;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

