/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import java.util.Arrays;

public enum PropertyType {
    ALLOW_ADDRESS(1),
    ALLOW_MOSAIC(2),
    ALLOW_TRANSACTION(4),
    SENTINEL(5),
    BLOCK_ADDRESS(129),
    BLOCK_MOSAIC(130),
    BLOCK_TRANSACTION(132);

    private final int value;

    private PropertyType(int value) {
        this.value = value;
    }

    public static PropertyType rawValueOf(String stringValue) {
        try {
            int value = Integer.decode(stringValue);
            return Arrays.stream(PropertyType.values()).filter(e -> e.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(stringValue + " is not a valid value"));
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException(stringValue + " is not a valid value");
        }
    }

    public int getValue() {
        return this.value;
    }
}

