/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.MultisigEntryBuilder;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.Address;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class MultisigAccountInfo
implements Stored {
    private final int version;
    private final String recordId;
    private final Address accountAddress;
    private final long minApproval;
    private final long minRemoval;
    private final List<Address> cosignatoryAddresses;
    private final List<Address> multisigAddresses;

    public MultisigAccountInfo(String recordId, int version, Address accountAddress, long minApproval, long minRemoval, List<Address> cosignatories, List<Address> multisigAddresses) {
        Validate.notNull((Object)accountAddress, (String)"accountAddress is required", (Object[])new Object[0]);
        Validate.notNull(cosignatories, (String)"cosignatories is required", (Object[])new Object[0]);
        Validate.notNull(multisigAddresses, (String)"multisigAddresses is required", (Object[])new Object[0]);
        this.version = version;
        this.recordId = recordId;
        this.accountAddress = accountAddress;
        this.minApproval = minApproval;
        this.minRemoval = minRemoval;
        this.cosignatoryAddresses = cosignatories;
        this.multisigAddresses = multisigAddresses;
    }

    public Address getAccountAddress() {
        return this.accountAddress;
    }

    public long getMinApproval() {
        return this.minApproval;
    }

    public long getMinRemoval() {
        return this.minRemoval;
    }

    public List<Address> getCosignatoryAddresses() {
        return this.cosignatoryAddresses;
    }

    public List<Address> getMultisigAddresses() {
        return this.multisigAddresses;
    }

    public boolean hasCosigner(Address account) {
        return this.cosignatoryAddresses.contains(account);
    }

    public boolean isCosignerOfMultisigAccount(Address account) {
        return this.multisigAddresses.contains(account);
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public boolean isMultisig() {
        return this.minApproval != 0L && this.minRemoval != 0L;
    }

    public byte[] serialize() {
        int minApproval = (int)this.getMinApproval();
        int minRemoval = (int)this.getMinRemoval();
        AddressDto accountAddress = SerializationUtils.toAddressDto(this.getAccountAddress());
        List cosignatoryAddresses = this.getCosignatoryAddresses().stream().map(SerializationUtils::toAddressDto).collect(Collectors.toList());
        List multisigAddresses = this.getMultisigAddresses().stream().map(SerializationUtils::toAddressDto).collect(Collectors.toList());
        return MultisigEntryBuilder.create((short)((short)this.getVersion()), (int)minApproval, (int)minRemoval, (AddressDto)accountAddress, cosignatoryAddresses, multisigAddresses).serialize();
    }
}

