/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.crypto.RawAddress;
import io.nem.symbol.core.utils.Base32Encoder;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.network.NetworkType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Address
implements UnresolvedAddress {
    private static final int PLAIN_ADDRESS_SIZE = 39;
    private static final int RAW_ADDRESS_SIZE = 24;
    private static final int CHECKSUM_SIZE = 3;
    private final String plainAddress;
    private final NetworkType networkType;

    public Address(String prettyOrRaw, NetworkType networkType) {
        this.plainAddress = Address.toPlainAddress((String)Validate.notNull((Object)prettyOrRaw, (String)"address must not be null", (Object[])new Object[0]));
        this.networkType = Objects.requireNonNull(networkType, "networkType must not be null");
        Optional<String> validationError = Address.validatePlainAddress(this.plainAddress);
        Validate.isTrue((!validationError.isPresent() ? 1 : 0) != 0, (String)validationError.orElse(""), (Object[])new Object[0]);
        char addressNetwork = this.plainAddress.charAt(0);
        Validate.isTrue((addressNetwork == this.networkType.getAddressPrefix() ? 1 : 0) != 0, (String)((Object)((Object)this.networkType) + " Address must start with " + this.networkType.getAddressPrefix()), (Object[])new Object[0]);
    }

    private static String toPlainAddress(String address) {
        return address.trim().toUpperCase().replace("-", "");
    }

    public static Address createFromRawAddress(String rawAddress) {
        Optional<String> validationError = Address.validatePlainAddress(Address.toPlainAddress(rawAddress));
        Validate.isTrue((!validationError.isPresent() ? 1 : 0) != 0, (String)validationError.orElse(""), (Object[])new Object[0]);
        return new Address(rawAddress, Address.resolveNetworkType(rawAddress));
    }

    private static NetworkType resolveNetworkType(String plainAddress) {
        char addressNetwork = plainAddress.charAt(0);
        return Arrays.stream(NetworkType.values()).filter(e -> e.getAddressPrefix() == addressNetwork).findFirst().orElseThrow(() -> new IllegalArgumentException(plainAddress + " is an invalid address."));
    }

    public static Address createFromEncoded(String encodedAddress) {
        return Address.createFromRawAddress(Address.fromEncodedToPlain(encodedAddress));
    }

    public static Address createFromPublicKey(String publicKey, NetworkType networkType) {
        return new Address(RawAddress.generateAddress(publicKey, networkType), networkType);
    }

    public static boolean isValidPlainAddress(String plainAddress) {
        return !Address.validatePlainAddress(plainAddress).isPresent();
    }

    public static boolean isValidEncodedAddress(String encodedAddress) {
        return !Address.validateEncodedAddress(encodedAddress).isPresent();
    }

    public static Optional<String> validateEncodedAddress(String encodedAddress) {
        try {
            if (encodedAddress == null) {
                return Optional.of("Encoded Address it nos provided");
            }
            String plainAddress = Address.fromEncodedToPlain(encodedAddress);
            return Address.validatePlainAddress(plainAddress).map(message -> "Encoded address: " + encodedAddress + " is invalid. " + message);
        }
        catch (Exception e) {
            return Optional.of("Encoded address " + encodedAddress + " is invalid. Error: " + ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public static Optional<String> validatePlainAddress(String plainAddress) {
        try {
            byte[] providedChecksum;
            if (plainAddress == null) {
                return Optional.of("Plain Address it nos provided");
            }
            if (plainAddress.length() != 39) {
                return Optional.of("Plain address '" + plainAddress + "' size is " + plainAddress.length() + " when " + 39 + " is required");
            }
            if ("AIQY".indexOf(plainAddress.charAt(plainAddress.toUpperCase().length() - 1)) < 0) {
                return Optional.of("Plain address '" + plainAddress + "' doesn't end with A I, Q or Y");
            }
            byte[] decodedArray = Base32Encoder.getBytes(plainAddress);
            if (decodedArray.length != 24) {
                return Optional.of("Plain address '" + plainAddress + "' decoded address size is " + decodedArray.length + " when " + 24 + " is required");
            }
            int checksumBegin = 21;
            byte[] expectedChecksum = Arrays.copyOf(Hashes.sha3_256(new byte[][]{Arrays.copyOf(decodedArray, checksumBegin)}), 3);
            if (!Arrays.equals(expectedChecksum, providedChecksum = Arrays.copyOfRange(decodedArray, checksumBegin, decodedArray.length))) {
                return Optional.of("Plain address '" + plainAddress + "' checksum is incorrect. Address checksum is '" + ConvertUtils.toHex(providedChecksum) + "' when '" + ConvertUtils.toHex(expectedChecksum) + "' is expected");
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of("Plain address '" + plainAddress + "' is invalid. Error: " + ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public static Address generateRandom(NetworkType networkType) {
        return Address.createFromPublicKey(PublicKey.generateRandom().toHex(), networkType);
    }

    @Override
    public String plain() {
        return this.plainAddress;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Override
    public String encoded(NetworkType networkType) {
        return this.encoded();
    }

    public String encoded() {
        return Address.fromPlainToEncoded(this.plain());
    }

    public String pretty() {
        return this.plainAddress.replaceAll("(.{6})", "$1-");
    }

    private static String fromPlainToEncoded(String plain) {
        byte[] bytes = Base32Encoder.getBytes(plain);
        return ConvertUtils.toHex(bytes);
    }

    private static String fromEncodedToPlain(String encoded) {
        byte[] bytes = ConvertUtils.fromHexToBytes(encoded);
        String rawAddress = Base32Encoder.getString(bytes);
        return rawAddress.substring(0, rawAddress.length() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address1 = (Address)o;
        return Objects.equals(this.plainAddress, address1.plainAddress) && this.networkType == address1.networkType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.plainAddress, this.networkType});
    }
}

