/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.catapult.builders.AccountRestrictionAddressValueBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.AccountRestrictionMosaicValueBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionTransactionTypeValueBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionsBuilder;
import io.nem.symbol.catapult.builders.AccountRestrictionsInfoBuilder;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.sdk.infrastructure.BinarySerializationImpl;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.account.AccountRestriction;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class AccountRestrictions {
    private final int version;
    private final Address address;
    private final List<AccountRestriction> restrictions;

    public AccountRestrictions(int version, Address address, List<AccountRestriction> restrictions) {
        Validate.notNull((Object)address, (String)"address is required", (Object[])new Object[0]);
        Validate.notNull(restrictions, (String)"restrictions is required", (Object[])new Object[0]);
        this.version = version;
        this.address = address;
        this.restrictions = restrictions;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<AccountRestriction> getRestrictions() {
        return this.restrictions;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] serialize() {
        AddressDto address = SerializationUtils.toAddressDto(this.getAddress());
        List restrictions = this.getRestrictions().stream().map(this::toAccountRestrictionsInfoBuilder).collect(Collectors.toList());
        return AccountRestrictionsBuilder.create((short)((short)this.getVersion()), (AddressDto)address, restrictions).serialize();
    }

    private AccountRestrictionsInfoBuilder toAccountRestrictionsInfoBuilder(AccountRestriction restriction) {
        EnumSet<AccountRestrictionFlagsDto> restrictionFlags = BinarySerializationImpl.toAccountRestrictionsFlagsDto(restriction.getRestrictionFlags().getFlags());
        AccountRestrictionAddressValueBuilder addressRestrictions = this.toAccountRestrictionAddressValueBuilder(restriction);
        AccountRestrictionMosaicValueBuilder mosaicIdRestrictions = this.toAccountRestrictionMosaicValueBuilder(restriction);
        AccountRestrictionTransactionTypeValueBuilder transactionTypeRestrictions = this.toAccountRestrictionTransactionTypeValueBuilder(restriction);
        return AccountRestrictionsInfoBuilder.create(restrictionFlags, (AccountRestrictionAddressValueBuilder)addressRestrictions, (AccountRestrictionMosaicValueBuilder)mosaicIdRestrictions, (AccountRestrictionTransactionTypeValueBuilder)transactionTypeRestrictions);
    }

    private AccountRestrictionAddressValueBuilder toAccountRestrictionAddressValueBuilder(AccountRestriction restriction) {
        return AccountRestrictionAddressValueBuilder.create(restriction.getValues().stream().filter(o -> o instanceof Address).map(o -> SerializationUtils.toAddressDto((Address)o)).collect(Collectors.toList()));
    }

    private AccountRestrictionMosaicValueBuilder toAccountRestrictionMosaicValueBuilder(AccountRestriction restriction) {
        return AccountRestrictionMosaicValueBuilder.create(restriction.getValues().stream().filter(o -> o instanceof MosaicId).map(o -> SerializationUtils.toMosaicIdDto((MosaicId)o)).collect(Collectors.toList()));
    }

    private AccountRestrictionTransactionTypeValueBuilder toAccountRestrictionTransactionTypeValueBuilder(AccountRestriction restriction) {
        return AccountRestrictionTransactionTypeValueBuilder.create(restriction.getValues().stream().filter(o -> o instanceof TransactionType).map(o -> EntityTypeDto.rawValueOf((short)((short)((TransactionType)((Object)((Object)o))).getValue()))).collect(Collectors.toList()));
    }
}

