/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.catapult.builders.AccountKeyTypeFlagsDto;
import io.nem.symbol.catapult.builders.AccountStateBuilder;
import io.nem.symbol.catapult.builders.AccountTypeDto;
import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.HeightActivityBucketBuilder;
import io.nem.symbol.catapult.builders.HeightActivityBucketsBuilder;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.ImportanceDto;
import io.nem.symbol.catapult.builders.ImportanceHeightDto;
import io.nem.symbol.catapult.builders.ImportanceSnapshotBuilder;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.PinnedVotingKeyBuilder;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.sdk.infrastructure.SerializationUtils;
import io.nem.symbol.sdk.model.Stored;
import io.nem.symbol.sdk.model.account.AccountLinkVotingKey;
import io.nem.symbol.sdk.model.account.AccountType;
import io.nem.symbol.sdk.model.account.ActivityBucket;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.Importance;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.account.SupplementalAccountKeys;
import io.nem.symbol.sdk.model.mosaic.ResolvedMosaic;
import java.math.BigInteger;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;

public class AccountInfo
implements Stored {
    private final String recordId;
    private final int version;
    private final Address address;
    private final BigInteger addressHeight;
    private final PublicKey publicKey;
    private final BigInteger publicKeyHeight;
    private final Importance importance;
    private final List<ResolvedMosaic> mosaics;
    private final AccountType accountType;
    private final SupplementalAccountKeys supplementalAccountKeys;
    private final List<ActivityBucket> activityBuckets;

    public AccountInfo(String recordId, int version, Address address, BigInteger addressHeight, PublicKey publicKey, BigInteger publicKeyHeight, BigInteger importance, BigInteger importanceHeight, List<ResolvedMosaic> mosaics, AccountType accountType, SupplementalAccountKeys supplementalAccountKeys, List<ActivityBucket> activityBuckets) {
        Validate.notNull((Object)address, (String)"address is required", (Object[])new Object[0]);
        Validate.notNull((Object)addressHeight, (String)"addressHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)publicKey, (String)"publicKey is required", (Object[])new Object[0]);
        Validate.notNull((Object)publicKeyHeight, (String)"publicKeyHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)importance, (String)"importance is required", (Object[])new Object[0]);
        Validate.notNull((Object)importanceHeight, (String)"importanceHeight is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)accountType), (String)"accountType is required", (Object[])new Object[0]);
        Validate.notNull((Object)supplementalAccountKeys, (String)"supplementalAccountKeys is required", (Object[])new Object[0]);
        this.version = version;
        this.recordId = recordId;
        this.address = address;
        this.addressHeight = addressHeight;
        this.publicKey = publicKey;
        this.publicKeyHeight = publicKeyHeight;
        this.accountType = accountType;
        this.supplementalAccountKeys = supplementalAccountKeys;
        this.activityBuckets = (List)ObjectUtils.defaultIfNull(activityBuckets, Collections.emptyList());
        this.importance = new Importance(importance, importanceHeight);
        this.mosaics = (List)ObjectUtils.defaultIfNull(mosaics, Collections.emptyList());
    }

    @Override
    public Optional<String> getRecordId() {
        return Optional.ofNullable(this.recordId);
    }

    public Address getAddress() {
        return this.address;
    }

    public BigInteger getAddressHeight() {
        return this.addressHeight;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getPublicKeyHeight() {
        return this.publicKeyHeight;
    }

    public Importance getImportance() {
        return this.importance;
    }

    public List<ResolvedMosaic> getMosaics() {
        return this.mosaics;
    }

    public PublicAccount getPublicAccount() {
        return PublicAccount.createFromPublicKey(this.publicKey.toHex(), this.address.getNetworkType());
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public SupplementalAccountKeys getSupplementalAccountKeys() {
        return this.supplementalAccountKeys;
    }

    public List<ActivityBucket> getActivityBuckets() {
        return this.activityBuckets;
    }

    public boolean isHighValue() {
        return this.getImportance().getValue().compareTo(BigInteger.ZERO) > 0;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] serialize() {
        AddressDto address = SerializationUtils.toAddressDto(this.getAddress());
        HeightDto addressHeight = new HeightDto(this.getAddressHeight().longValue());
        KeyDto publicKey = SerializationUtils.toKeyDto(this.getPublicKey());
        HeightDto publicKeyHeight = new HeightDto(this.getPublicKeyHeight().longValue());
        AccountTypeDto accountType = AccountTypeDto.rawValueOf((byte)((byte)this.getAccountType().getValue()));
        EnumSet<AccountKeyTypeFlagsDto> supplementalPublicKeysMask = this.getAccountKeyTypeFlags();
        KeyDto linkedPublicKey = this.getSupplementalAccountKeys().getLinked().map(SerializationUtils::toKeyDto).orElse(null);
        KeyDto nodePublicKey = this.getSupplementalAccountKeys().getNode().map(SerializationUtils::toKeyDto).orElse(null);
        KeyDto vrfPublicKey = this.getSupplementalAccountKeys().getVrf().map(SerializationUtils::toKeyDto).orElse(null);
        List votingPublicKeys = this.getSupplementalAccountKeys().getVoting().stream().map(this::toPinnedVotingKeyBuilder).collect(Collectors.toList());
        ImportanceDto importanceValue = new ImportanceDto(this.getImportance().getValue().longValue());
        ImportanceHeightDto importanceHeight = new ImportanceHeightDto(this.getImportance().getHeight().longValue());
        ImportanceSnapshotBuilder importanceSnapshots = ImportanceSnapshotBuilder.create((ImportanceDto)importanceValue, (ImportanceHeightDto)importanceHeight);
        HeightActivityBucketsBuilder activityBuckets = this.toHeightActivityBucketsBuilder();
        List<MosaicBuilder> balances = SerializationUtils.toMosaicBuilders(this.getMosaics());
        if (this.isHighValue()) {
            return AccountStateBuilder.createHighValue((short)((short)this.getVersion()), (AddressDto)address, (HeightDto)addressHeight, (KeyDto)publicKey, (HeightDto)publicKeyHeight, (AccountTypeDto)accountType, supplementalPublicKeysMask, (KeyDto)linkedPublicKey, (KeyDto)nodePublicKey, (KeyDto)vrfPublicKey, votingPublicKeys, (ImportanceSnapshotBuilder)importanceSnapshots, (HeightActivityBucketsBuilder)activityBuckets, balances).serialize();
        }
        return AccountStateBuilder.createRegular((short)((short)this.getVersion()), (AddressDto)address, (HeightDto)addressHeight, (KeyDto)publicKey, (HeightDto)publicKeyHeight, (AccountTypeDto)accountType, supplementalPublicKeysMask, (KeyDto)linkedPublicKey, (KeyDto)nodePublicKey, (KeyDto)vrfPublicKey, votingPublicKeys, balances).serialize();
    }

    private HeightActivityBucketsBuilder toHeightActivityBucketsBuilder() {
        List buckets = this.getActivityBuckets().stream().limit(5L).map(this::toHeightActivityBucketBuilder).collect(Collectors.toList());
        return HeightActivityBucketsBuilder.create(buckets);
    }

    private HeightActivityBucketBuilder toHeightActivityBucketBuilder(ActivityBucket activityBucket) {
        ImportanceHeightDto startHeight = new ImportanceHeightDto(activityBucket.getStartHeight().longValue());
        AmountDto totalFeesPaid = SerializationUtils.toAmount(activityBucket.getTotalFeesPaid());
        int beneficiaryCount = (int)activityBucket.getBeneficiaryCount();
        long rawScore = activityBucket.getRawScore().longValue();
        return HeightActivityBucketBuilder.create((ImportanceHeightDto)startHeight, (AmountDto)totalFeesPaid, (int)beneficiaryCount, (long)rawScore);
    }

    private PinnedVotingKeyBuilder toPinnedVotingKeyBuilder(AccountLinkVotingKey accountLinkVotingKey) {
        VotingKeyDto votingKey = SerializationUtils.toVotingKeyDto(accountLinkVotingKey.getPublicKey());
        FinalizationEpochDto startEpoch = new FinalizationEpochDto((int)accountLinkVotingKey.getStartEpoch());
        FinalizationEpochDto endEpoch = new FinalizationEpochDto((int)accountLinkVotingKey.getEndEpoch());
        return PinnedVotingKeyBuilder.create((VotingKeyDto)votingKey, (FinalizationEpochDto)startEpoch, (FinalizationEpochDto)endEpoch);
    }

    private EnumSet<AccountKeyTypeFlagsDto> getAccountKeyTypeFlags() {
        EnumSet<AccountKeyTypeFlagsDto> flags = EnumSet.of(AccountKeyTypeFlagsDto.UNSET);
        if (this.getSupplementalAccountKeys().getVrf().isPresent()) {
            flags.add(AccountKeyTypeFlagsDto.VRF);
        }
        if (this.getSupplementalAccountKeys().getNode().isPresent()) {
            flags.add(AccountKeyTypeFlagsDto.NODE);
        }
        if (this.getSupplementalAccountKeys().getLinked().isPresent()) {
            flags.add(AccountKeyTypeFlagsDto.LINKED);
        }
        return flags;
    }
}

