/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.model.account;

import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.DsaSigner;
import io.nem.symbol.core.crypto.KeyPair;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.CosignatureTransaction;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import java.util.List;

public class Account {
    private final KeyPair keyPair;
    private final PublicAccount publicAccount;
    private final NetworkType networkType;

    public Account(String privateKey, NetworkType networkType) {
        this.keyPair = KeyPair.fromPrivate(PrivateKey.fromHexString(privateKey));
        this.publicAccount = new PublicAccount(this.getPublicKey(), networkType);
        this.networkType = networkType;
    }

    public Account(KeyPair keyPair, NetworkType networkType) {
        this.keyPair = keyPair;
        this.publicAccount = new PublicAccount(this.getPublicKey(), networkType);
        this.networkType = networkType;
    }

    public static Account createFromPrivateKey(String privateKey, NetworkType networkType) {
        return new Account(privateKey, networkType);
    }

    public static Account generateNewAccount(NetworkType networkType) {
        return new Account(KeyPair.random(), networkType);
    }

    public String getPublicKey() {
        return this.keyPair.getPublicKey().toHex();
    }

    public String getPrivateKey() {
        return this.keyPair.getPrivateKey().toHex();
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public Address getAddress() {
        return this.publicAccount.getAddress();
    }

    public PublicAccount getPublicAccount() {
        return this.publicAccount;
    }

    public SignedTransaction sign(Transaction transaction, String generationHash) {
        return transaction.signWith(this, generationHash);
    }

    public CosignatureSignedTransaction signCosignatureTransaction(CosignatureTransaction cosignatureTransaction) {
        return cosignatureTransaction.signWith(this);
    }

    public CosignatureSignedTransaction signCosignatureTransaction(String transactionHash) {
        DsaSigner signer = CryptoEngines.defaultEngine().createDsaSigner(this.getKeyPair());
        byte[] bytes = ConvertUtils.fromHexToBytes(transactionHash);
        byte[] signatureBytes = signer.sign(bytes).getBytes();
        return new CosignatureSignedTransaction(AggregateTransactionCosignature.DEFAULT_VERSION, transactionHash, ConvertUtils.toHex(signatureBytes), this.getPublicAccount());
    }

    public SignedTransaction signTransactionWithCosignatories(AggregateTransaction transaction, List<Account> cosignatories, String generationHash) {
        return transaction.signTransactionWithCosigners(this, cosignatories, generationHash);
    }

    public SignedTransaction signTransactionGivenSignatures(AggregateTransaction transaction, List<AggregateTransactionCosignature> cosignatures, String generationHash) {
        return transaction.signTransactionGivenSignatures(this, cosignatures, generationHash);
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }
}

