/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.sdk.api.Listener;
import io.nem.symbol.sdk.api.ReceiptPaginationStreamer;
import io.nem.symbol.sdk.api.ReceiptRepository;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.api.ResolutionStatementSearchCriteria;
import io.nem.symbol.sdk.api.TransactionRepository;
import io.nem.symbol.sdk.api.TransactionService;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.receipt.AddressResolutionStatement;
import io.nem.symbol.sdk.model.receipt.MosaicResolutionStatement;
import io.nem.symbol.sdk.model.receipt.ReceiptSource;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.AccountAddressRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.AccountMosaicRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionFactory;
import io.nem.symbol.sdk.model.transaction.HashLockTransaction;
import io.nem.symbol.sdk.model.transaction.HashLockTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicAddressRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicAddressRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyChangeTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyChangeTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyRevocationTransaction;
import io.nem.symbol.sdk.model.transaction.MosaicSupplyRevocationTransactionFactory;
import io.nem.symbol.sdk.model.transaction.SecretLockTransaction;
import io.nem.symbol.sdk.model.transaction.SecretLockTransactionFactory;
import io.nem.symbol.sdk.model.transaction.SecretProofTransaction;
import io.nem.symbol.sdk.model.transaction.SecretProofTransactionFactory;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionAnnounceResponse;
import io.nem.symbol.sdk.model.transaction.TransactionFactory;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.model.transaction.TransactionInfo;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.nem.symbol.sdk.model.transaction.TransferTransaction;
import io.nem.symbol.sdk.model.transaction.TransferTransactionFactory;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.BiFunction;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class TransactionServiceImpl
implements TransactionService {
    private final TransactionRepository transactionRepository;
    private final ReceiptRepository receiptRepository;

    public TransactionServiceImpl(RepositoryFactory repositoryFactory) {
        this.transactionRepository = repositoryFactory.createTransactionRepository();
        this.receiptRepository = repositoryFactory.createReceiptRepository();
    }

    @Override
    public Observable<Transaction> announce(Listener listener, SignedTransaction signedTransaction) {
        Validate.notNull((Object)signedTransaction, (String)"signedTransaction is required", (Object[])new Object[0]);
        Observable<TransactionAnnounceResponse> announce = this.transactionRepository.announce(signedTransaction);
        return announce.flatMap(r -> listener.confirmedOrError(signedTransaction.getSigner().getAddress(), signedTransaction.getHash()));
    }

    @Override
    public Observable<AggregateTransaction> announceAggregateBonded(Listener listener, SignedTransaction signedAggregateTransaction) {
        Validate.notNull((Object)signedAggregateTransaction, (String)"signedAggregateTransaction is required", (Object[])new Object[0]);
        Validate.isTrue((signedAggregateTransaction.getType() == TransactionType.AGGREGATE_BONDED ? 1 : 0) != 0, (String)"signedAggregateTransaction type must be AGGREGATE_BONDED", (Object[])new Object[0]);
        Observable<TransactionAnnounceResponse> announce = this.transactionRepository.announceAggregateBonded(signedAggregateTransaction);
        return announce.flatMap(r -> listener.aggregateBondedAddedOrError(signedAggregateTransaction.getSigner().getAddress(), signedAggregateTransaction.getHash()));
    }

    @Override
    public Observable<AggregateTransaction> announceHashLockAggregateBonded(Listener listener, SignedTransaction signedHashLockTransaction, SignedTransaction signedAggregateTransaction) {
        Validate.notNull((Object)signedHashLockTransaction, (String)"signedHashLockTransaction is required", (Object[])new Object[0]);
        Validate.notNull((Object)signedAggregateTransaction, (String)"signedAggregateTransaction is required", (Object[])new Object[0]);
        Validate.isTrue((signedAggregateTransaction.getType() == TransactionType.AGGREGATE_BONDED ? 1 : 0) != 0, (String)"signedAggregateTransaction type must be AGGREGATE_BONDED", (Object[])new Object[0]);
        Validate.isTrue((signedHashLockTransaction.getType() == TransactionType.HASH_LOCK ? 1 : 0) != 0, (String)"signedHashLockTransaction type must be LOCK", (Object[])new Object[0]);
        return this.announce(listener, signedHashLockTransaction).flatMap(t -> this.announceAggregateBonded(listener, signedAggregateTransaction));
    }

    @Override
    public Observable<List<Transaction>> resolveAliases(List<String> transactionHashes) {
        return this.transactionRepository.getTransactions(TransactionGroup.CONFIRMED, transactionHashes).flatMapIterable(a -> a).flatMap(transaction -> this.resolveTransaction((Transaction)transaction, this.createExpectedReceiptSource((Transaction)transaction))).toList().toObservable();
    }

    private Observable<Transaction> resolveTransaction(Transaction transaction, ReceiptSource expectedSource) {
        Observable<List<AddressResolutionStatement>> addressResolutionStatements = this.getAddressResolutionStatements(transaction);
        Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements = this.getMosaicResolutionStatements(transaction);
        return this.resolveTransaction(transaction, expectedSource, addressResolutionStatements, mosaicResolutionStatements);
    }

    private Observable<Transaction> resolveTransaction(Transaction transaction, ReceiptSource expectedSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        return this.basicTransactionFactory(transaction, expectedSource, addressResolutionStatements, mosaicResolutionStatements).map(transactionTransactionFactory -> this.completeAndBuild((TransactionFactory<? extends Transaction>)transactionTransactionFactory, transaction));
    }

    private Observable<TransactionFactory<? extends Transaction>> basicTransactionFactory(final Transaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        if (transaction.getType() == TransactionType.TRANSFER) {
            return this.resolveTransactionFactory((TransferTransaction)transaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.HASH_LOCK) {
            return this.resolveTransactionFactory((HashLockTransaction)transaction, expectedReceiptSource, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.SECRET_LOCK) {
            return this.resolveTransactionFactory((SecretLockTransaction)transaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.SECRET_PROOF) {
            return this.resolveTransactionFactory((SecretProofTransaction)transaction, expectedReceiptSource, addressResolutionStatements);
        }
        if (transaction.getType() == TransactionType.MOSAIC_GLOBAL_RESTRICTION) {
            return this.resolveTransactionFactory((MosaicGlobalRestrictionTransaction)transaction, expectedReceiptSource, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.MOSAIC_ADDRESS_RESTRICTION) {
            return this.resolveTransactionFactory((MosaicAddressRestrictionTransaction)transaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.ACCOUNT_MOSAIC_RESTRICTION) {
            return this.resolveTransactionFactory((AccountMosaicRestrictionTransaction)transaction, expectedReceiptSource, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.MOSAIC_METADATA) {
            return this.resolveTransactionFactory((MosaicMetadataTransaction)transaction, expectedReceiptSource, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.ACCOUNT_ADDRESS_RESTRICTION) {
            return this.resolveTransactionFactory((AccountAddressRestrictionTransaction)transaction, expectedReceiptSource, addressResolutionStatements);
        }
        if (transaction.getType() == TransactionType.MOSAIC_SUPPLY_CHANGE) {
            return this.resolveTransactionFactory((MosaicSupplyChangeTransaction)transaction, expectedReceiptSource, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.MOSAIC_SUPPLY_REVOCATION) {
            return this.resolveTransactionFactory((MosaicSupplyRevocationTransaction)transaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }
        if (transaction.getType() == TransactionType.AGGREGATE_COMPLETE || transaction.getType() == TransactionType.AGGREGATE_BONDED) {
            return this.resolveTransactionFactory((AggregateTransaction)transaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }
        return Observable.just((Object)new TransactionFactory<Transaction>(transaction.getType(), transaction.getNetworkType(), transaction.getDeadline()){

            @Override
            public Transaction build() {
                return transaction;
            }
        });
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(HashLockTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<Mosaic> resolvedMosaic = this.getResolvedMosaic(transaction, transaction.getMosaic(), mosaicResolutionStatements, expectedReceiptSource);
        return resolvedMosaic.map(mosaic -> HashLockTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), mosaic, transaction.getDuration(), transaction.getHash()));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(SecretLockTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<Address> resolvedAddress = this.getResolvedAddress(transaction, transaction.getRecipient(), addressResolutionStatements, expectedReceiptSource);
        Observable<Mosaic> resolvedMosaic = this.getResolvedMosaic(transaction, transaction.getMosaic(), mosaicResolutionStatements, expectedReceiptSource);
        return Observable.combineLatest(resolvedAddress, resolvedMosaic, (address, mosaic) -> SecretLockTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), mosaic, transaction.getDuration(), transaction.getHashAlgorithm(), transaction.getSecret(), address));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(SecretProofTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements) {
        Observable<Address> resolvedAddress = this.getResolvedAddress(transaction, transaction.getRecipient(), addressResolutionStatements, expectedReceiptSource);
        return resolvedAddress.map(address -> SecretProofTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), transaction.getHashType(), address, transaction.getSecret(), transaction.getProof()));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(TransferTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable resolvedMosaics = Observable.fromIterable(transaction.getMosaics()).flatMap(m -> this.getResolvedMosaic(transaction, (Mosaic)m, mosaicResolutionStatements, expectedReceiptSource)).toList().toObservable();
        Observable<Address> resolvedRecipient = this.getResolvedAddress(transaction, transaction.getRecipient(), addressResolutionStatements, expectedReceiptSource);
        BiFunction mergeFunction = (address, mosaics) -> TransferTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), address, mosaics).message(transaction.getMessage().orElse(null));
        return Observable.combineLatest(resolvedRecipient, (ObservableSource)resolvedMosaics, (BiFunction)mergeFunction);
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(MosaicGlobalRestrictionTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<MosaicId> resolvedMosaicId = this.getResolvedMosaicId(transaction, transaction.getMosaicId(), mosaicResolutionStatements, expectedReceiptSource);
        Observable<MosaicId> resolvedReferenceMosaicId = this.getResolvedMosaicId(transaction, transaction.getReferenceMosaicId(), mosaicResolutionStatements, expectedReceiptSource);
        return Observable.combineLatest(resolvedMosaicId, resolvedReferenceMosaicId, (mosaicId, referenceMosaicId) -> {
            MosaicGlobalRestrictionTransactionFactory factory = MosaicGlobalRestrictionTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), mosaicId, transaction.getRestrictionKey(), transaction.getNewRestrictionValue(), transaction.getNewRestrictionType());
            if (referenceMosaicId != null) {
                factory.referenceMosaicId((UnresolvedMosaicId)referenceMosaicId);
            }
            return factory.previousRestrictionValue(transaction.getPreviousRestrictionValue()).previousRestrictionType(transaction.getPreviousRestrictionType());
        });
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(MosaicAddressRestrictionTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<MosaicId> resolvedMosaicId = this.getResolvedMosaicId(transaction, transaction.getMosaicId(), mosaicResolutionStatements, expectedReceiptSource);
        Observable resolvedTargetAddress = Observable.just((Object)transaction.getTargetAddress()).flatMap(m -> this.getResolvedAddress(transaction, (UnresolvedAddress)m, addressResolutionStatements, expectedReceiptSource));
        BiFunction mapper = (mosaicId, targetAddress) -> MosaicAddressRestrictionTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), mosaicId, transaction.getRestrictionKey(), targetAddress, transaction.getNewRestrictionValue()).previousRestrictionValue(transaction.getPreviousRestrictionValue());
        return Observable.combineLatest(resolvedMosaicId, (ObservableSource)resolvedTargetAddress, (BiFunction)mapper);
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(AccountMosaicRestrictionTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<List<UnresolvedMosaicId>> unresolvedAdditions = this.getResolvedMosaicIds(transaction, transaction.getRestrictionAdditions(), mosaicResolutionStatements, expectedReceiptSource);
        Observable<List<UnresolvedMosaicId>> unresolvedDeletions = this.getResolvedMosaicIds(transaction, transaction.getRestrictionDeletions(), mosaicResolutionStatements, expectedReceiptSource);
        BiFunction mapper = (additions, deletions) -> AccountMosaicRestrictionTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), transaction.getRestrictionFlags(), additions, deletions);
        return Observable.combineLatest(unresolvedAdditions, unresolvedDeletions, (BiFunction)mapper);
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(AccountAddressRestrictionTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements) {
        Observable<List<UnresolvedAddress>> unresolvedAdditions = this.getResolvedAddresses(transaction, transaction.getRestrictionAdditions(), addressResolutionStatements, expectedReceiptSource);
        Observable<List<UnresolvedAddress>> unresolvedDeletions = this.getResolvedAddresses(transaction, transaction.getRestrictionDeletions(), addressResolutionStatements, expectedReceiptSource);
        BiFunction mapper = (additions, deletions) -> AccountAddressRestrictionTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), transaction.getRestrictionFlags(), additions, deletions);
        return Observable.combineLatest(unresolvedAdditions, unresolvedDeletions, (BiFunction)mapper);
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(MosaicMetadataTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<MosaicId> resolvedMosaicId = this.getResolvedMosaicId(transaction, transaction.getTargetMosaicId(), mosaicResolutionStatements, expectedReceiptSource);
        return resolvedMosaicId.map(mosaicId -> MosaicMetadataTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), transaction.getTargetAddress(), mosaicId, transaction.getScopedMetadataKey(), transaction.getValue()).valueSizeDelta(transaction.getValueSizeDelta()).valueSize(transaction.getValueSize()));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(MosaicSupplyChangeTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<MosaicId> resolvedMosaicId = this.getResolvedMosaicId(transaction, transaction.getMosaicId(), mosaicResolutionStatements, expectedReceiptSource);
        return resolvedMosaicId.map(mosaicId -> MosaicSupplyChangeTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), mosaicId, transaction.getAction(), transaction.getDelta()));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(MosaicSupplyRevocationTransaction transaction, ReceiptSource expectedReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable<Address> resolvedAddress = this.getResolvedAddress(transaction, transaction.getSourceAddress(), addressResolutionStatements, expectedReceiptSource);
        Observable<Mosaic> resolvedMosaic = this.getResolvedMosaic(transaction, transaction.getMosaic(), mosaicResolutionStatements, expectedReceiptSource);
        return Observable.combineLatest(resolvedAddress, resolvedMosaic, (address, mosaic) -> MosaicSupplyRevocationTransactionFactory.create(transaction.getNetworkType(), transaction.getDeadline(), address, mosaic));
    }

    private Observable<TransactionFactory<? extends Transaction>> resolveTransactionFactory(AggregateTransaction transaction, ReceiptSource aggregateTransactionReceiptSource, Observable<List<AddressResolutionStatement>> addressResolutionStatements, Observable<List<MosaicResolutionStatement>> mosaicResolutionStatements) {
        Observable innerTransactions = Observable.just(transaction.getInnerTransactions()).flatMapIterable(m -> m).flatMap(innerTransaction -> {
            ReceiptSource expectedReceiptSource = this.createExpectedReceiptSource(aggregateTransactionReceiptSource, (Transaction)innerTransaction);
            return this.resolveTransaction((Transaction)innerTransaction, expectedReceiptSource, addressResolutionStatements, mosaicResolutionStatements);
        }).toList().toObservable();
        return innerTransactions.map(txs -> AggregateTransactionFactory.create(transaction.getType(), transaction.getNetworkType(), transaction.getDeadline(), txs, transaction.getCosignatures()));
    }

    private Transaction completeAndBuild(TransactionFactory<? extends Transaction> transactionFactory, Transaction transaction) {
        transactionFactory.maxFee(transaction.getMaxFee());
        transactionFactory.version(transaction.getVersion());
        transaction.getSignature().ifPresent(transactionFactory::signature);
        transaction.getSigner().ifPresent(transactionFactory::signer);
        transaction.getTransactionInfo().ifPresent(transactionFactory::transactionInfo);
        return transactionFactory.build();
    }

    private Observable<List<MosaicResolutionStatement>> getMosaicResolutionStatements(Transaction transaction) {
        BigInteger height = this.getTransactionInfo(transaction).getHeight();
        return ReceiptPaginationStreamer.mosaics(this.receiptRepository).search(new ResolutionStatementSearchCriteria().height(height)).toList().toObservable().cache();
    }

    private Observable<List<AddressResolutionStatement>> getAddressResolutionStatements(Transaction transaction) {
        BigInteger height = this.getTransactionInfo(transaction).getHeight();
        return ReceiptPaginationStreamer.addresses(this.receiptRepository).search(new ResolutionStatementSearchCriteria().height(height)).toList().toObservable().cache();
    }

    private Observable<List<UnresolvedMosaicId>> getResolvedMosaicIds(Transaction transaction, List<UnresolvedMosaicId> unresolvedMosaicIds, Observable<List<MosaicResolutionStatement>> statementObservable, ReceiptSource expectedReceiptSource) {
        return Observable.fromIterable(unresolvedMosaicIds).flatMap(unresolved -> this.getResolvedMosaicId(transaction, (UnresolvedMosaicId)unresolved, statementObservable, expectedReceiptSource)).map(m -> m).toList().toObservable();
    }

    private Observable<List<UnresolvedAddress>> getResolvedAddresses(Transaction transaction, List<UnresolvedAddress> unresolvedMosaicIds, Observable<List<AddressResolutionStatement>> statementObservable, ReceiptSource expectedReceiptSource) {
        return Observable.fromIterable(unresolvedMosaicIds).flatMap(unresolved -> this.getResolvedAddress(transaction, (UnresolvedAddress)unresolved, statementObservable, expectedReceiptSource)).map(m -> m).toList().toObservable();
    }

    private Observable<Mosaic> getResolvedMosaic(Transaction transaction, Mosaic unresolvedMosaic, Observable<List<MosaicResolutionStatement>> statementObservable, ReceiptSource expectedReceiptSource) {
        return this.getResolvedMosaicId(transaction, unresolvedMosaic.getId(), statementObservable, expectedReceiptSource).map(mId -> new Mosaic((UnresolvedMosaicId)mId, unresolvedMosaic.getAmount()));
    }

    private Observable<MosaicId> getResolvedMosaicId(Transaction transaction, UnresolvedMosaicId unresolvedMosaicId, Observable<List<MosaicResolutionStatement>> statementObservable, ReceiptSource expectedReceiptSource) {
        BigInteger height = this.getTransactionInfo(transaction).getHeight();
        return statementObservable.map(statements -> MosaicResolutionStatement.getResolvedMosaicId(statements, height, unresolvedMosaicId, expectedReceiptSource.getPrimaryId(), expectedReceiptSource.getSecondaryId()).orElseThrow(() -> new IllegalArgumentException("MosaicId could not be resolved for alias " + unresolvedMosaicId.getIdAsHex())));
    }

    private Observable<Address> getResolvedAddress(Transaction transaction, UnresolvedAddress unresolvedAddress, Observable<List<AddressResolutionStatement>> statementObservable, ReceiptSource expectedReceiptSource) {
        BigInteger height = this.getTransactionInfo(transaction).getHeight();
        return statementObservable.map(statements -> AddressResolutionStatement.getResolvedAddress(statements, height, unresolvedAddress, expectedReceiptSource.getPrimaryId(), expectedReceiptSource.getSecondaryId()).orElseThrow(() -> new IllegalArgumentException("Address could not be resolved for alias " + ((NamespaceId)unresolvedAddress).getIdAsHex())));
    }

    private ReceiptSource createExpectedReceiptSource(Transaction transaction) {
        int transactionIndex = (Integer)transaction.getTransactionInfo().flatMap(TransactionInfo::getIndex).orElseThrow(() -> new IllegalArgumentException("TransactionIndex cannot be loaded from Transaction " + (Object)((Object)transaction.getType())));
        return new ReceiptSource(transactionIndex + 1, 0L);
    }

    private ReceiptSource createExpectedReceiptSource(ReceiptSource aggregateTransactionReceiptSource, Transaction transaction) {
        int transactionIndex = (Integer)transaction.getTransactionInfo().flatMap(TransactionInfo::getIndex).orElseThrow(() -> new IllegalArgumentException("TransactionIndex cannot be loaded from Transaction " + (Object)((Object)transaction.getType())));
        return new ReceiptSource(aggregateTransactionReceiptSource.getPrimaryId(), transactionIndex + 1);
    }

    private TransactionInfo getTransactionInfo(Transaction transaction) {
        return transaction.getTransactionInfo().orElseThrow(() -> new IllegalArgumentException("Transaction Info is required in " + (Object)((Object)transaction.getType()) + " transaction"));
    }
}

