/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.NamespaceSearchCriteria;
import io.nem.symbol.sdk.api.PaginationStreamer;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.api.StateProofService;
import io.nem.symbol.sdk.model.account.AccountInfo;
import io.nem.symbol.sdk.model.account.AccountRestrictions;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.MultisigAccountInfo;
import io.nem.symbol.sdk.model.blockchain.MerkleStateInfo;
import io.nem.symbol.sdk.model.metadata.Metadata;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicInfo;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceInfo;
import io.nem.symbol.sdk.model.namespace.NamespaceRegistrationType;
import io.nem.symbol.sdk.model.restriction.MosaicRestriction;
import io.nem.symbol.sdk.model.state.StateMerkleProof;
import io.nem.symbol.sdk.model.transaction.HashLockInfo;
import io.nem.symbol.sdk.model.transaction.SecretLockInfo;
import io.reactivex.Observable;

public class StateProofServiceImpl
implements StateProofService {
    private final RepositoryFactory repositoryFactory;

    public StateProofServiceImpl(RepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    @Override
    public Observable<StateMerkleProof<MosaicInfo>> mosaic(MosaicId mosaicId) {
        return this.repositoryFactory.createMosaicRepository().getMosaic(mosaicId).flatMap(this::mosaic);
    }

    @Override
    public Observable<StateMerkleProof<MosaicInfo>> mosaic(MosaicInfo state) {
        MosaicId id = state.getMosaicId();
        return this.repositoryFactory.createMosaicRepository().getMosaicMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<MosaicRestriction<?>>> mosaicRestriction(String compositeHash) {
        return this.repositoryFactory.createRestrictionMosaicRepository().getMosaicRestrictions(compositeHash).flatMap(this::mosaicRestriction);
    }

    @Override
    public Observable<StateMerkleProof<MosaicRestriction<?>>> mosaicRestriction(MosaicRestriction<?> state) {
        String id = state.getCompositeHash();
        return this.repositoryFactory.createRestrictionMosaicRepository().getMosaicRestrictionsMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<HashLockInfo>> hashLock(String hash) {
        return this.repositoryFactory.createHashLockRepository().getHashLock(hash).flatMap(this::hashLock);
    }

    @Override
    public Observable<StateMerkleProof<HashLockInfo>> hashLock(HashLockInfo state) {
        String id = state.getHash();
        return this.repositoryFactory.createHashLockRepository().getHashLockMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<SecretLockInfo>> secretLock(String compositeHash) {
        return this.repositoryFactory.createSecretLockRepository().getSecretLock(compositeHash).flatMap(this::secretLock);
    }

    @Override
    public Observable<StateMerkleProof<SecretLockInfo>> secretLock(SecretLockInfo state) {
        String id = state.getCompositeHash();
        return this.repositoryFactory.createSecretLockRepository().getSecretLockMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<Metadata>> metadata(String compositeHash) {
        return this.repositoryFactory.createMetadataRepository().getMetadata(compositeHash).flatMap(this::metadata);
    }

    @Override
    public Observable<StateMerkleProof<Metadata>> metadata(Metadata state) {
        String id = state.getCompositeHash();
        return this.repositoryFactory.createMetadataRepository().getMetadataMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<AccountRestrictions>> accountRestrictions(Address address) {
        return this.repositoryFactory.createRestrictionAccountRepository().getAccountRestrictions(address).flatMap(this::accountRestrictions);
    }

    @Override
    public Observable<StateMerkleProof<AccountRestrictions>> accountRestrictions(AccountRestrictions state) {
        Address id = state.getAddress();
        return this.repositoryFactory.createRestrictionAccountRepository().getAccountRestrictionsMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<AccountInfo>> account(Address address) {
        return this.repositoryFactory.createAccountRepository().getAccountInfo(address).flatMap(this::account);
    }

    @Override
    public Observable<StateMerkleProof<AccountInfo>> account(AccountInfo state) {
        Address id = state.getAddress();
        return this.repositoryFactory.createAccountRepository().getAccountInfoMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<MultisigAccountInfo>> multisig(Address address) {
        return this.repositoryFactory.createMultisigRepository().getMultisigAccountInfo(address).flatMap(this::multisig);
    }

    @Override
    public Observable<StateMerkleProof<MultisigAccountInfo>> multisig(MultisigAccountInfo state) {
        Address id = state.getAccountAddress();
        return this.repositoryFactory.createMultisigRepository().getMultisigAccountInfoMerkle(id).map(merkle -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, state.serialize()));
    }

    @Override
    public Observable<StateMerkleProof<NamespaceInfo>> namespace(NamespaceId namespaceId) {
        return this.repositoryFactory.createNamespaceRepository().getNamespace(namespaceId).flatMap(this::namespace);
    }

    @Override
    public Observable<StateMerkleProof<NamespaceInfo>> namespace(NamespaceInfo state) {
        NamespaceId id = state.getId();
        NamespaceRepository namespaceRepository = this.repositoryFactory.createNamespaceRepository();
        PaginationStreamer streamer = namespaceRepository.streamer();
        return namespaceRepository.getNamespaceMerkle(id).flatMap(merkle -> streamer.search(new NamespaceSearchCriteria().level0(state.getId().getIdAsHex()).registrationType(NamespaceRegistrationType.SUB_NAMESPACE)).toList().toObservable().map(state::serialize).map(s -> this.toStateMerkleProof((Object)state, (MerkleStateInfo)merkle, (byte[])s)));
    }

    private <S> StateMerkleProof<S> toStateMerkleProof(S state, MerkleStateInfo merkle, byte[] serialized) {
        if (merkle.getRaw().isEmpty()) {
            throw new IllegalStateException("Merkle tree is empty!");
        }
        String stateHash = ConvertUtils.toHex(Hashes.sha3_256(new byte[][]{serialized}));
        return new StateMerkleProof<S>(state, stateHash, merkle.getTree(), merkle.getRaw());
    }
}

