/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.FinalizationEpochDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.MosaicBuilder;
import io.nem.symbol.catapult.builders.MosaicFlagsDto;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import io.nem.symbol.catapult.builders.VotingKeyDto;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.crypto.VotingKey;
import io.nem.symbol.core.utils.Base32Encoder;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.core.utils.StringEncoder;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.Mosaic;
import io.nem.symbol.sdk.model.mosaic.MosaicFlags;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.ResolvedMosaic;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static PublicAccount toPublicAccount(KeyDto keyDto, NetworkType networkType) {
        return PublicAccount.createFromPublicKey(ConvertUtils.toHex(keyDto.getKey().array()), networkType);
    }

    public static Mosaic toMosaic(UnresolvedMosaicBuilder builder) {
        return new Mosaic(new MosaicId(SerializationUtils.toUnsignedBigInteger(builder.getMosaicId().getUnresolvedMosaicId())), SerializationUtils.toUnsignedBigInteger(builder.getAmount().getAmount()));
    }

    public static UnresolvedMosaicId toUnresolvedMosaicId(UnresolvedMosaicIdDto dto) {
        return new MosaicId(SerializationUtils.toUnsignedBigInteger(dto.getUnresolvedMosaicId()));
    }

    public static MosaicId toMosaicId(MosaicIdDto dto) {
        return new MosaicId(SerializationUtils.toUnsignedBigInteger(dto.getMosaicId()));
    }

    public static NamespaceId toNamespaceId(NamespaceIdDto dto) {
        return NamespaceId.createFromId(SerializationUtils.toUnsignedBigInteger(dto.getNamespaceId()));
    }

    public static ByteBuffer fromUnresolvedAddressToByteBuffer(UnresolvedAddress unresolvedAddress, NetworkType networkType) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress must not be null", (Object[])new Object[0]);
        if (unresolvedAddress instanceof NamespaceId) {
            ByteBuffer namespaceIdAlias = ByteBuffer.allocate(24);
            NamespaceId namespaceId = (NamespaceId)unresolvedAddress;
            byte firstByte = (byte)(networkType.getValue() | 1);
            namespaceIdAlias.order(ByteOrder.LITTLE_ENDIAN);
            namespaceIdAlias.put(firstByte);
            namespaceIdAlias.putLong(namespaceId.getIdAsLong());
            return ByteBuffer.wrap(namespaceIdAlias.array());
        }
        if (unresolvedAddress instanceof Address) {
            return SerializationUtils.fromAddressToByteBuffer((Address)unresolvedAddress);
        }
        throw new IllegalArgumentException("Unexpected UnresolvedAddress type " + unresolvedAddress.getClass());
    }

    public static ByteBuffer fromAddressToByteBuffer(Address resolvedAddress) {
        return ByteBuffer.wrap(Base32Encoder.getBytes(resolvedAddress.plain()));
    }

    public static AddressDto toAddressDto(Address resolvedAddress) {
        return new AddressDto(SerializationUtils.fromAddressToByteBuffer(resolvedAddress));
    }

    public static Address toAddress(AddressDto dto) {
        return Address.createFromEncoded(ConvertUtils.toHex(dto.getAddress().array()));
    }

    public static UnresolvedAddressDto toUnresolvedAddress(UnresolvedAddress unresolvedAddress, NetworkType networkType) {
        return new UnresolvedAddressDto(SerializationUtils.fromUnresolvedAddressToByteBuffer(unresolvedAddress, networkType));
    }

    public static UnresolvedAddress toUnresolvedAddress(UnresolvedAddressDto dto) {
        return MapperUtils.toUnresolvedAddress(ConvertUtils.toHex(dto.getUnresolvedAddress().array()));
    }

    public static int byteToUnsignedInt(byte value) {
        return value & 0xFF;
    }

    public static int shortToUnsignedInt(short value) {
        return value & 0xFFFF;
    }

    public static long intToUnsignedLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static DataInputStream toDataInput(byte[] payload) {
        return new DataInputStream(new ByteArrayInputStream(payload));
    }

    public static BigInteger toUnsignedBigInteger(AmountDto amountDto) {
        return SerializationUtils.toUnsignedBigInteger(amountDto.getAmount());
    }

    public static BigInteger toUnsignedBigInteger(long value) {
        return ConvertUtils.toUnsignedBigInteger(value);
    }

    public static String toHexString(Hash256Dto dto) {
        return ConvertUtils.toHex(dto.getHash256().array()).toUpperCase();
    }

    public static long toUnsignedLong(BigInteger number) {
        ConvertUtils.validateNotNegative(number);
        return number.longValue();
    }

    public static String toHexString(ByteBuffer buffer) {
        return ConvertUtils.toHex(buffer.array()).toUpperCase();
    }

    public static String toString(ByteBuffer buffer) {
        return StringEncoder.getString(buffer.array());
    }

    public static byte[] concat(byte[] commonBytes, byte[] transactionBytes) {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(commonBytes.length + transactionBytes.length));
            dataOutputStream.write(commonBytes, 4, commonBytes.length - 4);
            dataOutputStream.write(transactionBytes);
        });
    }

    public static ByteBuffer toByteBuffer(PublicAccount publicAccount) {
        byte[] bytes = publicAccount.getPublicKey().getBytes();
        return ByteBuffer.wrap(bytes);
    }

    public static SignatureDto toSignatureDto(String signature) {
        return new SignatureDto(ByteBuffer.wrap(ConvertUtils.getBytes(signature)));
    }

    public static KeyDto toKeyDto(PublicKey publicKey) {
        return new KeyDto(ByteBuffer.wrap(publicKey.getBytes()));
    }

    public static PublicKey toPublicKey(KeyDto dto) {
        return new PublicKey(dto.getKey().array());
    }

    public static VotingKey toVotingKey(VotingKeyDto votingKeyDto) {
        return new VotingKey(votingKeyDto.getVotingKey().array());
    }

    public static VotingKeyDto toVotingKeyDto(VotingKey key) {
        return new VotingKeyDto(ByteBuffer.wrap(key.getBytes()));
    }

    public static VotingKeyDto toVotingKeyDto(String key) {
        return new VotingKeyDto(ByteBuffer.wrap(ConvertUtils.fromHexToBytes(key)));
    }

    public static Hash256Dto toHash256Dto(String hash) {
        return new Hash256Dto(ByteBuffer.wrap(ConvertUtils.fromHexToBytes(hash)));
    }

    public static UnresolvedMosaicIdDto toUnresolvedMosaicIdDto(UnresolvedMosaicId mosaicId) {
        return new UnresolvedMosaicIdDto(mosaicId.getId().longValue());
    }

    public static MosaicIdDto toMosaicIdDto(MosaicId mosaicId) {
        return new MosaicIdDto(mosaicId.getId().longValue());
    }

    public static FinalizationEpochDto toFinalizationEpochDto(long finalizationEpoch) {
        return new FinalizationEpochDto((int)finalizationEpoch);
    }

    public static List<MosaicBuilder> toMosaicBuilders(List<ResolvedMosaic> mosaics) {
        return mosaics.stream().map(SerializationUtils::toMosaicBuilder).collect(Collectors.toList());
    }

    private static MosaicBuilder toMosaicBuilder(ResolvedMosaic mosaic) {
        return MosaicBuilder.create((MosaicIdDto)SerializationUtils.toMosaicIdDto(mosaic.getId()), (AmountDto)SerializationUtils.toAmount(mosaic.getAmount()));
    }

    public static AmountDto toAmount(BigInteger amount) {
        return new AmountDto(SerializationUtils.toUnsignedLong(amount));
    }

    public static EnumSet<MosaicFlagsDto> getMosaicFlagsEnumSet(MosaicFlags flags) {
        EnumSet<MosaicFlagsDto> mosaicFlagsBuilder = EnumSet.of(MosaicFlagsDto.NONE);
        if (flags.isSupplyMutable()) {
            mosaicFlagsBuilder.add(MosaicFlagsDto.SUPPLY_MUTABLE);
        }
        if (flags.isTransferable()) {
            mosaicFlagsBuilder.add(MosaicFlagsDto.TRANSFERABLE);
        }
        if (flags.isRestrictable()) {
            mosaicFlagsBuilder.add(MosaicFlagsDto.RESTRICTABLE);
        }
        if (flags.isRevokable()) {
            mosaicFlagsBuilder.add(MosaicFlagsDto.REVOKABLE);
        }
        return mosaicFlagsBuilder;
    }
}

