/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.utils.FormatUtils;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.api.RepositoryFactoryConfiguration;
import io.nem.symbol.sdk.infrastructure.CurrencyServiceImpl;
import io.nem.symbol.sdk.model.mosaic.Currency;
import io.nem.symbol.sdk.model.mosaic.NetworkCurrencies;
import io.nem.symbol.sdk.model.network.NetworkConfiguration;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.node.NodeInfo;
import io.reactivex.Observable;
import java.time.Duration;
import java.util.concurrent.Callable;

public abstract class RepositoryFactoryBase
implements RepositoryFactory {
    private final String baseUrl;
    private final Observable<NetworkType> networkType;
    private final Observable<String> generationHashSeed;
    private final Observable<NetworkConfiguration> remoteNetworkConfiguration;
    private final Observable<NetworkCurrencies> networkCurrencies;
    private final Observable<Duration> epochAdjustment;

    public RepositoryFactoryBase(RepositoryFactoryConfiguration configuration) {
        this.baseUrl = configuration.getBaseUrl();
        this.networkType = RepositoryFactoryBase.createLazyObservable(configuration.getNetworkType(), () -> this.createNetworkRepository().getNetworkType());
        this.generationHashSeed = RepositoryFactoryBase.createLazyObservable(configuration.getGenerationHash(), () -> this.createNodeRepository().getNodeInfo().map(NodeInfo::getNetworkGenerationHashSeed));
        this.remoteNetworkConfiguration = Observable.defer(() -> this.createNetworkRepository().getNetworkProperties()).cache();
        this.networkCurrencies = RepositoryFactoryBase.createLazyObservable(configuration.getNetworkCurrencies(), this::loadNetworkCurrencies);
        this.epochAdjustment = RepositoryFactoryBase.createLazyObservable(configuration.getEpochAdjustment(), this::loadEpochAdjustment);
    }

    private static <T> Observable<T> createLazyObservable(T providedValue, Callable<Observable<T>> remoteObservable) {
        if (providedValue != null) {
            return Observable.just(providedValue);
        }
        return Observable.defer(remoteObservable).cache();
    }

    protected Observable<NetworkCurrencies> loadNetworkCurrencies() {
        return new CurrencyServiceImpl(this).getNetworkCurrencies();
    }

    protected Observable<Duration> loadEpochAdjustment() {
        return this.remoteNetworkConfiguration.map(cs -> {
            if (cs.getNetwork() == null || cs.getNetwork().getEpochAdjustment() == null) {
                throw new IllegalStateException("EpochAdjustment could not be loaded from Rest's network Properties.");
            }
            return FormatUtils.parseServerDuration(cs.getNetwork().getEpochAdjustment());
        });
    }

    @Override
    public Observable<NetworkType> getNetworkType() {
        return this.networkType;
    }

    @Override
    public Observable<String> getGenerationHash() {
        return this.generationHashSeed;
    }

    protected String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public Observable<Currency> getNetworkCurrency() {
        return this.getNetworkCurrencies().map(NetworkCurrencies::getCurrency);
    }

    @Override
    public Observable<Currency> getHarvestCurrency() {
        return this.getNetworkCurrencies().map(NetworkCurrencies::getHarvest);
    }

    @Override
    public Observable<NetworkCurrencies> getNetworkCurrencies() {
        return this.networkCurrencies;
    }

    @Override
    public Observable<Duration> getEpochAdjustment() {
        return this.epochAdjustment;
    }
}

