/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.sdk.api.AliasService;
import io.nem.symbol.sdk.api.MosaicRestrictionPaginationStreamer;
import io.nem.symbol.sdk.api.MosaicRestrictionSearchCriteria;
import io.nem.symbol.sdk.api.MosaicRestrictionTransactionService;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.api.RestrictionMosaicRepository;
import io.nem.symbol.sdk.infrastructure.AliasServiceImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.restriction.MosaicGlobalRestrictionItem;
import io.nem.symbol.sdk.model.restriction.MosaicRestrictionEntryType;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MosaicAddressRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicGlobalRestrictionTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicRestrictionType;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Optional;

public class MosaicRestrictionTransactionServiceImpl
implements MosaicRestrictionTransactionService {
    private final Observable<NetworkType> networkTypeObservable;
    private final Observable<Duration> epochAdjustmentObservable;
    private final RestrictionMosaicRepository repository;
    private final AliasService aliasService;

    public MosaicRestrictionTransactionServiceImpl(RepositoryFactory repositoryFactory) {
        this.repository = repositoryFactory.createRestrictionMosaicRepository();
        this.networkTypeObservable = repositoryFactory.getNetworkType();
        this.epochAdjustmentObservable = repositoryFactory.getEpochAdjustment();
        this.aliasService = new AliasServiceImpl(repositoryFactory);
    }

    @Override
    public Observable<MosaicGlobalRestrictionTransactionFactory> createMosaicGlobalRestrictionTransactionFactory(UnresolvedMosaicId unresolvedMosaicId, BigInteger restrictionKey, BigInteger restrictionValue, MosaicRestrictionType restrictionType) {
        return Observable.combineLatest(this.networkTypeObservable, this.epochAdjustmentObservable, this.aliasService.resolveMosaicId(unresolvedMosaicId), (networkType, epochAdjustment, mosaicId) -> this.getGlobalRestrictionEntry((MosaicId)mosaicId, restrictionKey).map(optional -> {
            MosaicGlobalRestrictionTransactionFactory factory = MosaicGlobalRestrictionTransactionFactory.create(networkType, Deadline.create(epochAdjustment), unresolvedMosaicId, restrictionKey, restrictionValue, restrictionType);
            optional.ifPresent(mosaicGlobalRestrictionItem -> {
                factory.previousRestrictionValue(mosaicGlobalRestrictionItem.getRestrictionValue());
                factory.previousRestrictionType(mosaicGlobalRestrictionItem.getRestrictionType());
            });
            return factory;
        })).flatMap(f -> f);
    }

    @Override
    public Observable<MosaicAddressRestrictionTransactionFactory> createMosaicAddressRestrictionTransactionFactory(UnresolvedMosaicId unresolvedMosaicId, BigInteger restrictionKey, UnresolvedAddress unresolvedTargetAddress, BigInteger restrictionValue) {
        return Observable.combineLatest(this.networkTypeObservable, this.epochAdjustmentObservable, this.aliasService.resolveMosaicId(unresolvedMosaicId), this.aliasService.resolveAddress(unresolvedTargetAddress), (networkType, epochAdjustment, mosaicId, targetAddress) -> this.getGlobalRestrictionEntry((MosaicId)mosaicId, restrictionKey).flatMap(optional -> {
            if (!optional.isPresent()) {
                return Observable.error((Throwable)new IllegalArgumentException("Global restriction is not valid for RestrictionKey: " + restrictionKey));
            }
            return this.getCurrentMosaicAddressRestrictionValue((MosaicId)mosaicId, (Address)targetAddress, restrictionKey).map(optionalValue -> {
                MosaicAddressRestrictionTransactionFactory factory = MosaicAddressRestrictionTransactionFactory.create(networkType, Deadline.create(epochAdjustment), unresolvedMosaicId, restrictionKey, unresolvedTargetAddress, restrictionValue);
                optionalValue.ifPresent(factory::previousRestrictionValue);
                return factory;
            });
        })).flatMap(f -> f);
    }

    private Observable<Optional<BigInteger>> getCurrentMosaicAddressRestrictionValue(MosaicId mosaicId, Address targetAddress, BigInteger restrictionKey) {
        MosaicRestrictionSearchCriteria criteria = new MosaicRestrictionSearchCriteria().mosaicId(mosaicId).targetAddress(targetAddress).entryType(MosaicRestrictionEntryType.ADDRESS);
        return MosaicRestrictionPaginationStreamer.address(this.repository, criteria).map(r -> Optional.ofNullable((BigInteger)r.getRestrictions().get(restrictionKey))).first(Optional.empty()).toObservable();
    }

    private Observable<Optional<MosaicGlobalRestrictionItem>> getGlobalRestrictionEntry(MosaicId mosaicId, BigInteger restrictionKey) {
        MosaicRestrictionSearchCriteria criteria = new MosaicRestrictionSearchCriteria().mosaicId(mosaicId).entryType(MosaicRestrictionEntryType.GLOBAL);
        return MosaicRestrictionPaginationStreamer.global(this.repository, criteria).map(r -> Optional.ofNullable((MosaicGlobalRestrictionItem)r.getRestrictions().get(restrictionKey))).first(Optional.empty()).toObservable();
    }
}

