/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.core.utils.StringEncoder;
import io.nem.symbol.sdk.api.AliasService;
import io.nem.symbol.sdk.api.MetadataRepository;
import io.nem.symbol.sdk.api.MetadataSearchCriteria;
import io.nem.symbol.sdk.api.MetadataTransactionService;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.infrastructure.AliasServiceImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.metadata.Metadata;
import io.nem.symbol.sdk.model.metadata.MetadataType;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AccountMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.MetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.MosaicMetadataTransactionFactory;
import io.nem.symbol.sdk.model.transaction.NamespaceMetadataTransactionFactory;
import io.reactivex.Observable;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public class MetadataTransactionServiceImpl
implements MetadataTransactionService {
    private final MetadataRepository metadataRepository;
    private final Observable<NetworkType> networkTypeObservable;
    private final AliasService aliasService;
    private final Observable<Duration> epochAdjustmentObservable;

    public MetadataTransactionServiceImpl(RepositoryFactory factory) {
        this.metadataRepository = factory.createMetadataRepository();
        this.networkTypeObservable = factory.getNetworkType();
        this.epochAdjustmentObservable = factory.getEpochAdjustment();
        this.aliasService = new AliasServiceImpl(factory);
    }

    @Override
    public Observable<AccountMetadataTransactionFactory> createAccountMetadataTransactionFactory(Address targetAddress, BigInteger key, String value, Address sourceAddress) {
        TriFunction<byte[], NetworkType, Deadline, AccountMetadataTransactionFactory> factory = (newValue, networkType, deadline) -> AccountMetadataTransactionFactory.create(networkType, deadline, targetAddress, key, newValue);
        return this.processMetadata(new MetadataSearchCriteria().targetAddress(targetAddress).scopedMetadataKey(key).sourceAddress(sourceAddress).metadataType(MetadataType.ACCOUNT), factory, value);
    }

    @Override
    public Observable<MosaicMetadataTransactionFactory> createMosaicMetadataTransactionFactory(Address targetAddress, BigInteger key, String value, Address sourceAddress, UnresolvedMosaicId unresolvedTargetId) {
        return this.aliasService.resolveMosaicId(unresolvedTargetId).flatMap(targetId -> {
            TriFunction<byte[], NetworkType, Deadline, MosaicMetadataTransactionFactory> factory = (newValue, networkType, deadline) -> MosaicMetadataTransactionFactory.create(networkType, deadline, targetAddress, unresolvedTargetId, key, newValue);
            return this.processMetadata(new MetadataSearchCriteria().targetId((MosaicId)targetId).scopedMetadataKey(key).sourceAddress(sourceAddress).metadataType(MetadataType.MOSAIC), factory, value);
        });
    }

    @Override
    public Observable<NamespaceMetadataTransactionFactory> createNamespaceMetadataTransactionFactory(Address targetAddress, BigInteger key, String value, Address sourceAddress, NamespaceId targetId) {
        TriFunction<byte[], NetworkType, Deadline, NamespaceMetadataTransactionFactory> factory = (newValue, networkType, deadline) -> NamespaceMetadataTransactionFactory.create(networkType, deadline, targetAddress, targetId, key, newValue);
        return this.processMetadata(new MetadataSearchCriteria().targetId(targetId).scopedMetadataKey(key).sourceAddress(sourceAddress).metadataType(MetadataType.NAMESPACE), factory, value);
    }

    private <T extends MetadataTransactionFactory> Observable<T> processMetadata(MetadataSearchCriteria criteria, TriFunction<byte[], NetworkType, Deadline, T> transactionFactory, String newValue) {
        return Observable.combineLatest(this.networkTypeObservable, this.epochAdjustmentObservable, (networkType, epochAdjustment) -> this.metadataRepository.search(criteria).map(page -> {
            Deadline deadline = Deadline.create(epochAdjustment);
            if (page.getData().isEmpty()) {
                return (MetadataTransactionFactory)transactionFactory.apply(StringEncoder.getBytes(newValue), (NetworkType)((Object)networkType), deadline);
            }
            byte[] originalValue = ((Metadata)page.getData().get(0)).getValue();
            byte[] newValueBytes = StringEncoder.getBytes(newValue);
            byte[] xoredBytes = ConvertUtils.xor(originalValue, newValueBytes);
            MetadataTransactionFactory factory = (MetadataTransactionFactory)transactionFactory.apply(xoredBytes, (NetworkType)((Object)networkType), deadline);
            factory.valueSizeDelta(newValueBytes.length - originalValue.length);
            return factory;
        })).flatMap(f -> f);
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            Objects.requireNonNull(after);
            return (a, b, c) -> after.apply((R)this.apply(a, b, c));
        }
    }
}

