/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.sdk.infrastructure.ListenerChannel;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.FinalizedBlock;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionStatusError;
import org.apache.commons.lang3.Validate;

public class ListenerRequest<T> {
    private final ListenerChannel channel;
    private final UnresolvedAddress unresolvedAddress;
    private String transactionHash;
    private boolean orError;

    public ListenerRequest(ListenerChannel channel, UnresolvedAddress unresolvedAddress) {
        this.channel = channel;
        this.unresolvedAddress = unresolvedAddress;
    }

    public static ListenerRequest<BlockInfo> block() {
        return new ListenerRequest<BlockInfo>(ListenerChannel.BLOCK, null);
    }

    public static ListenerRequest<FinalizedBlock> finalizedBlock() {
        return new ListenerRequest<FinalizedBlock>(ListenerChannel.FINALIZED_BLOCK, null);
    }

    public static ListenerRequest<Transaction> unconfirmedAdded(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<Transaction>(ListenerChannel.UNCONFIRMED_ADDED, unresolvedAddress);
    }

    public static ListenerRequest<String> unconfirmedRemoved(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<String>(ListenerChannel.UNCONFIRMED_REMOVED, unresolvedAddress);
    }

    public static ListenerRequest<AggregateTransaction> aggregateBondedAdded(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<AggregateTransaction>(ListenerChannel.AGGREGATE_BONDED_ADDED, unresolvedAddress);
    }

    public static ListenerRequest<String> aggregateBondedRemoved(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<String>(ListenerChannel.AGGREGATE_BONDED_REMOVED, unresolvedAddress);
    }

    public static ListenerRequest<CosignatureSignedTransaction> cosignature(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<CosignatureSignedTransaction>(ListenerChannel.COSIGNATURE, unresolvedAddress);
    }

    public static ListenerRequest<Transaction> confirmed(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<Transaction>(ListenerChannel.CONFIRMED_ADDED, unresolvedAddress);
    }

    public static ListenerRequest<TransactionStatusError> status(UnresolvedAddress unresolvedAddress) {
        Validate.notNull((Object)unresolvedAddress, (String)"unresolvedAddress is required", (Object[])new Object[0]);
        return new ListenerRequest<TransactionStatusError>(ListenerChannel.STATUS, unresolvedAddress);
    }

    public ListenerRequest<T> transactionHash(String transactionHash) {
        Validate.isTrue((this.channel != ListenerChannel.FINALIZED_BLOCK ? 1 : 0) != 0, (String)"Cannot subscribe transaction hash on finalized block", (Object[])new Object[0]);
        Validate.isTrue((this.channel != ListenerChannel.BLOCK ? 1 : 0) != 0, (String)"Cannot subscribe transaction hash on block", (Object[])new Object[0]);
        this.transactionHash = transactionHash;
        return this;
    }

    public ListenerRequest<T> transactionHashOrError(String transactionHash) {
        Validate.notNull((Object)this.unresolvedAddress, (String)"transactionHash is required", (Object[])new Object[0]);
        Validate.isTrue((this.channel != ListenerChannel.STATUS ? 1 : 0) != 0, (String)"Cannot subscribe on error with Status", (Object[])new Object[0]);
        this.orError = true;
        return this.transactionHash(transactionHash);
    }

    public ListenerRequest<T> transactionHashOrError(String transactionHash, boolean orError) {
        if (orError) {
            this.transactionHashOrError(transactionHash);
        } else {
            this.orError = false;
            this.transactionHash = transactionHash;
        }
        return this;
    }

    public ListenerChannel getChannel() {
        return this.channel;
    }

    public UnresolvedAddress getUnresolvedAddress() {
        return this.unresolvedAddress;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public boolean isOrError() {
        return this.orError;
    }

    public String getTopic() {
        if (this.unresolvedAddress == null) {
            return this.channel.toString();
        }
        return this.channel.toString() + "/" + this.unresolvedAddress.plain();
    }
}

