/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.utils.MapperUtils;
import io.nem.symbol.sdk.api.Listener;
import io.nem.symbol.sdk.api.MultisigRepository;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.infrastructure.ListenerChannel;
import io.nem.symbol.sdk.infrastructure.ListenerMessage;
import io.nem.symbol.sdk.infrastructure.ListenerRequest;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.FinalizedBlock;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceName;
import io.nem.symbol.sdk.model.network.NetworkType;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.CosignatureSignedTransaction;
import io.nem.symbol.sdk.model.transaction.Deadline;
import io.nem.symbol.sdk.model.transaction.JsonHelper;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionGroup;
import io.nem.symbol.sdk.model.transaction.TransactionStatusError;
import io.nem.symbol.sdk.model.transaction.TransactionStatusException;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class ListenerBase
implements Listener {
    private final Subject<ListenerMessage<?>> messageSubject = PublishSubject.create();
    private final JsonHelper jsonHelper;
    private final NamespaceRepository namespaceRepository;
    private final MultisigRepository multisigRepository;
    private final Observable<NetworkType> networkTypeObservable;
    private String uid;

    protected ListenerBase(JsonHelper jsonHelper, NamespaceRepository namespaceRepository, MultisigRepository multisigRepository, Observable<NetworkType> networkTypeObservable) {
        this.jsonHelper = jsonHelper;
        this.namespaceRepository = namespaceRepository;
        this.multisigRepository = multisigRepository;
        this.networkTypeObservable = networkTypeObservable;
    }

    public void handle(Object wsPayload, CompletableFuture<Void> future) {
        if (this.jsonHelper.contains(wsPayload, "uid")) {
            this.uid = this.jsonHelper.getString(wsPayload, "uid");
            future.complete(null);
            return;
        }
        this.createListenerMessage(wsPayload).subscribe(arg_0 -> this.getMessageSubject().onNext(arg_0));
    }

    private Observable<ListenerMessage<?>> createListenerMessage(Object wsPayload) {
        String topic = this.jsonHelper.getString(wsPayload, "topic");
        Validate.notNull((Object)topic, (String)"Topic must be included in the WebSocket payload!", (Object[])new Object[0]);
        ListenerChannel channel = ListenerChannel.rawValueOf(StringUtils.substringBefore((String)topic, (String)"/"));
        String channelParams = StringUtils.substringAfter((String)topic, (String)"/");
        Object message = this.jsonHelper.getObject(wsPayload, "data");
        Validate.notNull((Object)message, (String)"Data must be included in the WebSocket payload!", (Object[])new Object[0]);
        switch (channel) {
            case CONFIRMED_ADDED: 
            case UNCONFIRMED_ADDED: 
            case AGGREGATE_BONDED_ADDED: {
                Transaction transaction = this.toTransaction(this.toGroup(channel), message);
                String transactionHash = transaction.getTransactionInfo().get().getHash().get();
                return Observable.just(new ListenerMessage<Transaction>(topic, channel, channelParams, transaction, transactionHash));
            }
            case BLOCK: {
                return Observable.just(new ListenerMessage<BlockInfo>(topic, channel, channelParams, this.toBlockInfo(message), null));
            }
            case FINALIZED_BLOCK: {
                return Observable.just(new ListenerMessage<FinalizedBlock>(topic, channel, channelParams, this.toFinalizedBlock(message), null));
            }
            case STATUS: {
                TransactionStatusError status = this.toStatus(message, channelParams);
                return Observable.just(new ListenerMessage<TransactionStatusError>(topic, channel, channelParams, status, status.getHash()));
            }
            case COSIGNATURE: {
                return this.networkTypeObservable.map(networkType -> {
                    CosignatureSignedTransaction cosignature = this.toCosignatureSignedTransaction(message, (NetworkType)((Object)networkType));
                    return new ListenerMessage<CosignatureSignedTransaction>(topic, channel, channelParams, cosignature, cosignature.getParentHash());
                });
            }
            case AGGREGATE_BONDED_REMOVED: 
            case UNCONFIRMED_REMOVED: {
                String hash = this.jsonHelper.getString(message, "meta", "hash");
                return Observable.just(new ListenerMessage<String>(topic, channel, channelParams, hash, hash));
            }
        }
        throw new IllegalArgumentException("Channel " + (Object)((Object)channel) + "is not supported.");
    }

    protected abstract FinalizedBlock toFinalizedBlock(Object var1);

    private TransactionStatusError toStatus(Object message, String channelParams) {
        UnresolvedAddress unresolvedAddress = this.getUnresolvedAddress(channelParams);
        String hash = this.jsonHelper.getString(message, "hash");
        String code = this.jsonHelper.getString(message, "code");
        Deadline deadline = new Deadline(new BigInteger(this.jsonHelper.getString(message, "deadline")));
        return new TransactionStatusError(unresolvedAddress, hash, code, deadline);
    }

    private TransactionGroup toGroup(ListenerChannel channel) {
        switch (channel) {
            case CONFIRMED_ADDED: {
                return TransactionGroup.CONFIRMED;
            }
            case AGGREGATE_BONDED_ADDED: {
                return TransactionGroup.PARTIAL;
            }
            case UNCONFIRMED_ADDED: {
                return TransactionGroup.UNCONFIRMED;
            }
        }
        throw new IllegalArgumentException("Cannot map channel " + (Object)((Object)channel) + " to a transaction group.");
    }

    @Override
    public Observable<BlockInfo> newBlock() {
        return this.subscribe(ListenerRequest.block()).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<FinalizedBlock> finalizedBlock() {
        return this.subscribe(ListenerRequest.finalizedBlock()).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<Transaction> confirmed(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.confirmed(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<Transaction> confirmedOrError(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.confirmed(unresolvedAddress).transactionHashOrError(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<Transaction> unconfirmedAdded(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.unconfirmedAdded(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<String> unconfirmedRemoved(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.unconfirmedRemoved(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<AggregateTransaction> aggregateBondedAdded(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.aggregateBondedAdded(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<String> aggregateBondedRemoved(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.aggregateBondedRemoved(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<TransactionStatusError> status(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.status(unresolvedAddress).transactionHash(transactionHash)).map(ListenerMessage::getMessage);
    }

    @Override
    public Observable<CosignatureSignedTransaction> cosignatureAdded(UnresolvedAddress unresolvedAddress, String parentTransactionHash) {
        return this.subscribe(ListenerRequest.cosignature(unresolvedAddress).transactionHash(parentTransactionHash)).map(ListenerMessage::getMessage);
    }

    private void validateOpen() {
        if (this.getUid() == null) {
            throw new IllegalStateException("Listener has not been opened yet. Please call the open method before subscribing.");
        }
    }

    @Override
    public Observable<AggregateTransaction> aggregateBondedAddedOrError(UnresolvedAddress unresolvedAddress, String transactionHash) {
        return this.subscribe(ListenerRequest.aggregateBondedAdded(unresolvedAddress).transactionHashOrError(transactionHash)).map(ListenerMessage::getMessage);
    }

    private <T> Observable<ListenerMessage<T>> getMessageOrError(ListenerRequest<T> request, Observable<ListenerMessage<T>> transactionListener) {
        Validate.notNull((Object)request.getUnresolvedAddress(), (String)"address is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getTransactionHash(), (String)"transactionHash is required", (Object[])new Object[0]);
        IllegalStateException caller = new IllegalStateException("The Caller");
        Observable errorListener = this.subscribe(ListenerRequest.status(request.getUnresolvedAddress()).transactionHash(request.getTransactionHash())).map(ListenerMessage::getMessage);
        Observable errorOrTransactionObservable = Observable.merge(transactionListener, (ObservableSource)errorListener).take(1L);
        return errorOrTransactionObservable.map(errorOrTransaction -> {
            if (errorOrTransaction instanceof TransactionStatusError) {
                throw new TransactionStatusException(caller, (TransactionStatusError)errorOrTransaction);
            }
            return (ListenerMessage)errorOrTransaction;
        });
    }

    @Override
    public <T> Observable<ListenerMessage<T>> subscribe(ListenerRequest<T> request) {
        Observable<ListenerMessage<T>> transactionObservable = this.basicSubscribe(request);
        if (request.isOrError()) {
            return this.getMessageOrError(request, transactionObservable);
        }
        return transactionObservable;
    }

    public <T> Observable<ListenerMessage<T>> basicSubscribe(ListenerRequest<T> request) {
        this.validateOpen();
        String topic = request.getTopic();
        String transactionHash = request.getTransactionHash();
        this.subscribeTo(topic);
        return this.getMessageSubject().filter(rawMessage -> rawMessage.getTopic().equalsIgnoreCase(topic)).map(listenerMessage -> listenerMessage).filter(rawMessage -> transactionHash == null || transactionHash.equalsIgnoreCase(rawMessage.getTransactionHash())).distinctUntilChanged(this::sameMessage);
    }

    private <T> boolean sameMessage(ListenerMessage<T> message1, ListenerMessage<T> message2) {
        if (message1.getChannel() != message2.getChannel()) {
            return false;
        }
        if (message1.getTransactionHash() == null) {
            return false;
        }
        if (message1.getChannel() == ListenerChannel.COSIGNATURE) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)message1.getTransactionHash(), (CharSequence)message2.getTransactionHash());
    }

    private Observable<Address> getAddress(UnresolvedAddress unresolvedAddress) {
        if (unresolvedAddress instanceof Address) {
            return Observable.just((Object)((Address)unresolvedAddress));
        }
        return Observable.defer(() -> this.namespaceRepository.getLinkedAddress((NamespaceId)unresolvedAddress).cache());
    }

    private UnresolvedAddress getUnresolvedAddress(String channelParams) {
        return MapperUtils.toUnresolvedAddressFromPlain(channelParams);
    }

    @Override
    public Observable<Set<UnresolvedAddress>> getAllMultisigAddressesAndAliases(UnresolvedAddress unresolvedAddress) {
        return this.getAddress(unresolvedAddress).flatMap(address -> this.multisigRepository.getMultisigAccountInfo((Address)address).map(mutlisig -> {
            HashSet<Address> allUnresolvedAddresses = new HashSet<Address>(mutlisig.getCosignatoryAddresses());
            allUnresolvedAddresses.add((Address)address);
            allUnresolvedAddresses.add((Address)unresolvedAddress);
            return allUnresolvedAddresses;
        }).onErrorReturn(e -> Collections.singleton(address))).flatMap(addresses -> Observable.merge((Iterable)addresses.stream().map(this::getAllAddressesAndAliases).collect(Collectors.toList())).toList().map(list -> list.stream().flatMap(Collection::stream).collect(Collectors.toSet())).toObservable());
    }

    @Override
    public Observable<Set<UnresolvedAddress>> getAllAddressesAndAliases(UnresolvedAddress unresolvedAddress) {
        return this.getAddress(unresolvedAddress).flatMap(address -> this.getNamespaceIds((Address)address).map(namespaces -> {
            HashSet<UnresolvedAddress> allUnresolvedAddresses = new HashSet<UnresolvedAddress>((Collection<UnresolvedAddress>)namespaces);
            allUnresolvedAddresses.add((UnresolvedAddress)address);
            allUnresolvedAddresses.add(unresolvedAddress);
            return allUnresolvedAddresses;
        }));
    }

    @Override
    public <T> Observable<ListenerMessage<T>> subscribeMultipleAddresses(ListenerChannel channel, Set<UnresolvedAddress> unresolvedAddresses, String transactionHash, boolean orError) {
        return Observable.merge((Iterable)unresolvedAddresses.stream().map(unresolvedAddress -> this.subscribe(new ListenerRequest(channel, (UnresolvedAddress)unresolvedAddress).transactionHashOrError(transactionHash, orError))).collect(Collectors.toList())).distinctUntilChanged(this::sameMessage);
    }

    private Observable<List<NamespaceId>> getNamespaceIds(Address address) {
        return Observable.defer(() -> this.namespaceRepository.getAccountsNames(Collections.singletonList(address)).map(accountNames -> accountNames.stream().flatMap(accountName -> accountName.getNames().stream().map(NamespaceName::getNamespaceId)).collect(Collectors.toList()))).cache();
    }

    protected abstract BlockInfo toBlockInfo(Object var1);

    protected abstract Transaction toTransaction(TransactionGroup var1, Object var2);

    protected abstract CosignatureSignedTransaction toCosignatureSignedTransaction(Object var1, NetworkType var2);

    protected abstract void subscribeTo(String var1);

    public Subject<ListenerMessage<?>> getMessageSubject() {
        return this.messageSubject;
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }
}

