/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.utils.FormatUtils;
import io.nem.symbol.sdk.api.CurrencyService;
import io.nem.symbol.sdk.api.MosaicRepository;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.NetworkRepository;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.model.mosaic.Currency;
import io.nem.symbol.sdk.model.mosaic.CurrencyBuilder;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.MosaicInfo;
import io.nem.symbol.sdk.model.mosaic.MosaicNames;
import io.nem.symbol.sdk.model.mosaic.NetworkCurrencies;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.nem.symbol.sdk.model.namespace.NamespaceName;
import io.reactivex.Observable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class CurrencyServiceImpl
implements CurrencyService {
    private final NetworkRepository networkRepository;
    private final MosaicRepository mosaicRepository;
    private final NamespaceRepository namespaceRepository;

    public CurrencyServiceImpl(RepositoryFactory repositoryFactory) {
        this.networkRepository = repositoryFactory.createNetworkRepository();
        this.mosaicRepository = repositoryFactory.createMosaicRepository();
        this.namespaceRepository = repositoryFactory.createNamespaceRepository();
    }

    @Override
    public Observable<NetworkCurrencies> getNetworkCurrencies() {
        return this.networkRepository.getNetworkProperties().flatMap(properties -> {
            MosaicId harvestingMosaicId;
            if (properties.getChain() == null || properties.getChain().getCurrencyMosaicId() == null) {
                return Observable.error((Throwable)new IllegalArgumentException("CurrencyMosaicId could not be loaded from network properties!!!"));
            }
            if (properties.getChain() == null || properties.getChain().getHarvestingMosaicId() == null) {
                return Observable.error((Throwable)new IllegalArgumentException("HarvestingMosaicId could not be loaded from network properties!!"));
            }
            MosaicId currencyMosaicId = new MosaicId(FormatUtils.toSimpleHex(properties.getChain().getCurrencyMosaicId()));
            List<MosaicId> mosaicIds = currencyMosaicId.equals(harvestingMosaicId = new MosaicId(FormatUtils.toSimpleHex(properties.getChain().getHarvestingMosaicId()))) ? Collections.singletonList(currencyMosaicId) : Arrays.asList(currencyMosaicId, harvestingMosaicId);
            return this.getCurrencies(mosaicIds).map(currencies -> {
                Currency currency = currencies.stream().filter(c -> c.getMosaicId().filter(mosaicId -> mosaicId.equals(currencyMosaicId)).isPresent()).findFirst().orElseThrow(() -> new IllegalArgumentException("There is no Main Currency with id " + currencyMosaicId));
                Currency harvest = currencies.stream().filter(c -> c.getMosaicId().filter(mosaicId -> mosaicId.equals(harvestingMosaicId)).isPresent()).findFirst().orElseThrow(() -> new IllegalArgumentException("There is no Harvest Currency with id " + harvestingMosaicId));
                return new NetworkCurrencies(currency, harvest);
            });
        });
    }

    @Override
    public Observable<Currency> getCurrency(MosaicId mosaicId) {
        return this.getCurrencies(Collections.singletonList(mosaicId)).map(list -> (Currency)list.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("There is no currency with id " + mosaicId.getIdAsHex())));
    }

    @Override
    public Observable<List<Currency>> getCurrencies(List<MosaicId> mosaicIds) {
        Validate.notNull(mosaicIds, (String)"mosaicIds is required", (Object[])new Object[0]);
        return this.mosaicRepository.getMosaics(mosaicIds).flatMap(mosaicInfos -> this.namespaceRepository.getMosaicsNames(mosaicIds).onErrorReturnItem(Collections.emptyList()).map(mosaicNames -> mosaicInfos.stream().map(mosaicInfo -> this.getCurrency((MosaicInfo)mosaicInfo, (List<MosaicNames>)mosaicNames)).collect(Collectors.toList())));
    }

    @Override
    public Observable<Currency> getCurrencyFromNamespaceId(NamespaceId namespaceId) {
        Validate.notNull((Object)namespaceId, (String)"namespaceId is required", (Object[])new Object[0]);
        return this.namespaceRepository.getLinkedMosaicId(namespaceId).flatMap(mosaicId -> this.mosaicRepository.getMosaic((MosaicId)mosaicId).flatMap(info -> this.namespaceRepository.getMosaicsNames(Collections.singletonList(mosaicId)).onErrorReturnItem(Collections.emptyList()).map(mosaicNames -> this.getCurrency((MosaicInfo)info, (List<MosaicNames>)mosaicNames))));
    }

    private CurrencyBuilder createCurrency(MosaicInfo mosaicInfo, Optional<NamespaceId> namespaceId) {
        MosaicId unresolvedMosaicId = mosaicInfo.getMosaicId();
        CurrencyBuilder builder = new CurrencyBuilder(unresolvedMosaicId, mosaicInfo.getDivisibility()).withMosaicId(mosaicInfo.getMosaicId()).withSupplyMutable(mosaicInfo.isSupplyMutable()).withTransferable(mosaicInfo.isTransferable()).withRestrictable(mosaicInfo.isRestrictable()).withRevokable(mosaicInfo.isRevokable());
        namespaceId.ifPresent(builder::withNamespaceId);
        return builder;
    }

    private Currency getCurrency(MosaicInfo mosaicInfo, List<MosaicNames> mosaicNamesList) {
        MosaicId mosaicId = mosaicInfo.getMosaicId();
        Optional<String> namespaceName = this.getName(mosaicNamesList, mosaicId);
        Optional<NamespaceId> namespaceId = namespaceName.map(NamespaceId::createFromName);
        return this.createCurrency(mosaicInfo, namespaceId).build();
    }

    private Optional<String> getName(List<MosaicNames> mosaicNames, MosaicId accountMosaicDto) {
        return mosaicNames.stream().filter(n -> n.getMosaicId().equals(accountMosaicDto)).flatMap(n -> n.getNames().stream().map(NamespaceName::getName)).findFirst();
    }
}

