/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.api.BlockRepository;
import io.nem.symbol.sdk.api.BlockService;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.model.blockchain.BlockInfo;
import io.nem.symbol.sdk.model.blockchain.MerklePathItem;
import io.nem.symbol.sdk.model.blockchain.MerkleProofInfo;
import io.nem.symbol.sdk.model.blockchain.Position;
import io.reactivex.Observable;
import io.reactivex.functions.BiFunction;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class BlockServiceImpl
implements BlockService {
    private final BlockRepository blockRepository;

    public BlockServiceImpl(RepositoryFactory repositoryFactory) {
        this.blockRepository = repositoryFactory.createBlockRepository();
    }

    @Override
    public Observable<Boolean> isValidTransactionInBlock(BigInteger height, String transactionHash) {
        Validate.notNull((Object)height, (String)"height is required", (Object[])new Object[0]);
        Validate.notNull((Object)transactionHash, (String)"transactionHash is required", (Object[])new Object[0]);
        return this.getBooleanObservable((Observable<String>)this.blockRepository.getBlockByHeight(height).map(BlockInfo::getBlockTransactionsHash), transactionHash, this.blockRepository.getMerkleTransaction(height, transactionHash));
    }

    @Override
    public Observable<Boolean> isValidStatementInBlock(BigInteger height, String statementHash) {
        Validate.notNull((Object)height, (String)"height is required", (Object[])new Object[0]);
        Validate.notNull((Object)statementHash, (String)"statementHash is required", (Object[])new Object[0]);
        return this.getBooleanObservable((Observable<String>)this.blockRepository.getBlockByHeight(height).map(BlockInfo::getBlockReceiptsHash), statementHash, this.blockRepository.getMerkleReceipts(height, statementHash));
    }

    private Observable<Boolean> getBooleanObservable(Observable<String> rootObservable, String leaf, Observable<MerkleProofInfo> merkleTransactionObservable) {
        BiFunction zipper = (root, merkleProofInfo) -> {
            List<MerklePathItem> merklePath = merkleProofInfo.getMerklePath();
            if (merklePath.isEmpty()) {
                return leaf.equalsIgnoreCase((String)root);
            }
            java.util.function.BiFunction<String, MerklePathItem, String> accumulator = (proofHash, pathItem) -> ConvertUtils.toHex(Hashes.sha3_256(new byte[][]{ConvertUtils.fromHexToBytes(pathItem.getPosition() == Position.LEFT ? pathItem.getHash() + proofHash : proofHash + pathItem.getHash())}));
            String hroot0 = merklePath.stream().reduce(leaf, accumulator, (s1, s2) -> s1);
            return root.equalsIgnoreCase(hroot0);
        };
        return Observable.zip(rootObservable, merkleTransactionObservable, (BiFunction)zipper).onErrorReturn(e -> {
            e.printStackTrace();
            return false;
        });
    }
}

