/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.sdk.api.AliasService;
import io.nem.symbol.sdk.api.NamespaceRepository;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.AliasType;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import io.reactivex.Observable;
import org.apache.commons.lang3.Validate;

public class AliasServiceImpl
implements AliasService {
    private final NamespaceRepository namespaceRepository;

    public AliasServiceImpl(RepositoryFactory repositoryFactory) {
        this.namespaceRepository = repositoryFactory.createNamespaceRepository();
    }

    @Override
    public Observable<MosaicId> resolveMosaicId(UnresolvedMosaicId unresolvedMosaicId) {
        if (unresolvedMosaicId instanceof NamespaceId) {
            NamespaceId alias = (NamespaceId)unresolvedMosaicId;
            return this.namespaceRepository.getNamespace(alias).map(namespaceInfo -> {
                Validate.isTrue((namespaceInfo.getAlias().getType() == AliasType.MOSAIC ? 1 : 0) != 0, (String)"Alias is not Mosaic", (Object[])new Object[0]);
                return (MosaicId)namespaceInfo.getAlias().getAliasValue();
            }).onErrorResumeNext(e -> Observable.error((Throwable)new IllegalArgumentException("MosaicId could not be resolved from alias " + alias.getIdAsHex(), (Throwable)e)));
        }
        return Observable.just((Object)((MosaicId)unresolvedMosaicId));
    }

    @Override
    public Observable<Address> resolveAddress(UnresolvedAddress unresolvedAddress) {
        if (unresolvedAddress instanceof NamespaceId) {
            NamespaceId alias = (NamespaceId)unresolvedAddress;
            return this.namespaceRepository.getNamespace(alias).map(namespaceInfo -> {
                Validate.isTrue((namespaceInfo.getAlias().getType() == AliasType.ADDRESS ? 1 : 0) != 0, (String)"Alias is not address", (Object[])new Object[0]);
                return (Address)namespaceInfo.getAlias().getAliasValue();
            }).onErrorResumeNext(e -> Observable.error((Throwable)new IllegalArgumentException("Address could not be resolved from alias " + alias.getIdAsHex(), (Throwable)e)));
        }
        return Observable.just((Object)((Address)unresolvedAddress));
    }
}

