/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.infrastructure;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.api.AggregateTransactionService;
import io.nem.symbol.sdk.api.MultisigRepository;
import io.nem.symbol.sdk.api.NetworkRepository;
import io.nem.symbol.sdk.api.RepositoryFactory;
import io.nem.symbol.sdk.infrastructure.BinarySerializationImpl;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.MultisigAccountGraphInfo;
import io.nem.symbol.sdk.model.account.MultisigAccountInfo;
import io.nem.symbol.sdk.model.account.PublicAccount;
import io.nem.symbol.sdk.model.transaction.AggregateTransaction;
import io.nem.symbol.sdk.model.transaction.AggregateTransactionCosignature;
import io.nem.symbol.sdk.model.transaction.MultisigAccountModificationTransaction;
import io.nem.symbol.sdk.model.transaction.SignedTransaction;
import io.nem.symbol.sdk.model.transaction.Transaction;
import io.nem.symbol.sdk.model.transaction.TransactionType;
import io.reactivex.Observable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public class AggregateTransactionServiceImpl
implements AggregateTransactionService {
    private final MultisigRepository multisigRepository;
    private final NetworkRepository networkRepository;

    public AggregateTransactionServiceImpl(RepositoryFactory repositoryFactory) {
        this.multisigRepository = repositoryFactory.createMultisigRepository();
        this.networkRepository = repositoryFactory.createNetworkRepository();
    }

    @Override
    public Observable<Boolean> isComplete(SignedTransaction signedTransaction) {
        Validate.notNull((Object)signedTransaction, (String)"signedTransaction is required", (Object[])new Object[0]);
        Validate.isTrue((signedTransaction.getType() == TransactionType.AGGREGATE_COMPLETE ? 1 : 0) != 0, (String)"signedTransaction type must be AGGREGATE_COMPLETE", (Object[])new Object[0]);
        AggregateTransaction transaction = (AggregateTransaction)BinarySerializationImpl.INSTANCE.deserialize(ConvertUtils.fromHexToBytes(signedTransaction.getPayload()));
        Set signers = transaction.getCosignatures().stream().map(AggregateTransactionCosignature::getSigner).map(PublicAccount::getAddress).collect(Collectors.toSet());
        signers.add(signedTransaction.getSigner().getAddress());
        return Observable.fromIterable(transaction.getInnerTransactions()).flatMap(innerTransaction -> this.multisigRepository.getMultisigAccountInfo(innerTransaction.getSigner().orElseThrow(IllegalArgumentException::new).getAddress()).flatMap(multisigAccountInfo -> multisigAccountInfo.getMinRemoval() != 0L && multisigAccountInfo.getMinApproval() != 0L ? this.multisigRepository.getMultisigAccountGraphInfo(multisigAccountInfo.getAccountAddress()).map(graphInfo -> this.validateCosignatories((MultisigAccountGraphInfo)graphInfo, signers, (Transaction)innerTransaction)) : Observable.just((Object)signers.stream().anyMatch(s -> s.equals(multisigAccountInfo.getAccountAddress()))))).all(v -> v).toObservable();
    }

    @Override
    public Observable<Integer> getMaxCosignatures(Address address) {
        return this.multisigRepository.getMultisigAccountGraphInfo(address).map(multisigAccountGraphInfo -> {
            Stream publicAccountStream = multisigAccountGraphInfo.getMultisigEntries().values().stream().flatMap(accounts -> accounts.stream().flatMap(account -> account.getCosignatoryAddresses().stream()));
            return publicAccountStream.collect(Collectors.toSet()).size();
        });
    }

    @Override
    public Observable<Integer> getNetworkMaxCosignaturesPerAggregate() {
        return this.networkRepository.getNetworkProperties().map(properties -> {
            if (properties.getPlugins() == null || properties.getPlugins().getAggregate() == null || properties.getPlugins().getAggregate().getMaxCosignaturesPerAggregate() == null) {
                throw new IllegalStateException("Cannot get maxCosignaturesPerAggregate from network properties.");
            }
            return Integer.parseInt(properties.getPlugins().getAggregate().getMaxCosignaturesPerAggregate().replace("'", ""));
        });
    }

    private boolean validateCosignatories(MultisigAccountGraphInfo graphInfo, Set<Address> cosignatories, Transaction innerTransaction) {
        HashSet<Address> cosignatoriesReceived = new HashSet<Address>(cosignatories);
        boolean isMultisigRemoval = innerTransaction.getType() == TransactionType.MULTISIG_ACCOUNT_MODIFICATION && !((MultisigAccountModificationTransaction)innerTransaction).getAddressDeletions().isEmpty();
        TreeMap<Integer, List<MultisigAccountInfo>> storedMap = new TreeMap<Integer, List<MultisigAccountInfo>>(graphInfo.getMultisigEntries());
        return storedMap.values().stream().anyMatch(entry -> entry.stream().allMatch(multisig -> {
            if (multisig.getMinApproval() > 0L && multisig.getMinRemoval() > 0L) {
                Set matchedCosignatories = multisig.getCosignatoryAddresses().stream().collect(Collectors.toSet());
                matchedCosignatories.retainAll(cosignatoriesReceived);
                if ((long)matchedCosignatories.size() >= multisig.getMinApproval() && !isMultisigRemoval || (long)matchedCosignatories.size() >= multisig.getMinRemoval() && isMultisigRemoval) {
                    cosignatoriesReceived.add(multisig.getAccountAddress());
                    return true;
                }
                return false;
            }
            return false;
        }));
    }
}

