/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.api;

import io.nem.symbol.sdk.api.SearchCriteria;
import io.nem.symbol.sdk.api.Searcher;
import io.reactivex.Observable;

public class PaginationStreamer<E, C extends SearchCriteria<C>> {
    private final Searcher<E, C> searcher;

    public PaginationStreamer(Searcher<E, C> searcher) {
        this.searcher = searcher;
    }

    public Observable<E> search(C criteria) {
        return this.search(criteria, 1);
    }

    private Observable<E> search(C criteria, Integer pageNumber) {
        ((SearchCriteria)criteria).pageNumber(pageNumber);
        return Observable.defer(() -> this.searcher.search((SearchCriteria)criteria)).flatMap(page -> {
            if (page.isLast()) {
                return Observable.fromIterable(page.getData());
            }
            return Observable.fromIterable(page.getData()).concatWith(this.search(criteria, pageNumber + 1));
        });
    }
}

