/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.utils;

import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.account.Address;
import io.nem.symbol.sdk.model.account.UnresolvedAddress;
import io.nem.symbol.sdk.model.mosaic.MosaicId;
import io.nem.symbol.sdk.model.mosaic.UnresolvedMosaicId;
import io.nem.symbol.sdk.model.namespace.NamespaceId;
import java.math.BigInteger;

public class MapperUtils {
    private MapperUtils() {
    }

    public static NamespaceId toNamespaceId(String hex) {
        return hex == null ? null : NamespaceId.createFromId(MapperUtils.fromHexToBigInteger(hex));
    }

    public static MosaicId toMosaicId(String hex) {
        return hex == null ? null : new MosaicId(MapperUtils.fromHexToBigInteger(hex));
    }

    public static UnresolvedMosaicId toUnresolvedMosaicId(String hex) {
        if (hex == null) {
            return null;
        }
        if ((ConvertUtils.getBytes(hex)[0] & 0x80) == 128) {
            return MapperUtils.toNamespaceId(hex);
        }
        return MapperUtils.toMosaicId(hex);
    }

    public static UnresolvedAddress toUnresolvedAddress(String hex) {
        if (hex == null) {
            return null;
        }
        byte bit0 = ConvertUtils.getBytes(hex.substring(1, 3))[0];
        if ((bit0 & 0x10) == 16) {
            return MapperUtils.toNamespaceId(ConvertUtils.reverseHexString(hex.substring(2, 18)));
        }
        return Address.createFromEncoded(hex);
    }

    public static Address toAddressFromRawAddress(String rawAddress) {
        return rawAddress != null ? Address.createFromRawAddress(rawAddress) : null;
    }

    public static BigInteger fromHexToBigInteger(String hex) {
        return new BigInteger(hex, 16);
    }

    public static String fromBigIntegerToHex(BigInteger value) {
        return ConvertUtils.toSize16Hex(value);
    }

    public static Address toAddress(String encodedAddress) {
        return encodedAddress != null ? Address.createFromEncoded(encodedAddress) : null;
    }

    public static String getIdAsHex(UnresolvedMosaicId id) {
        return id == null ? null : id.getIdAsHex();
    }

    public static UnresolvedAddress toUnresolvedAddressFromPlain(String plainUnresolvedAddress) {
        try {
            if (Address.isValidPlainAddress(plainUnresolvedAddress)) {
                return Address.createFromRawAddress(plainUnresolvedAddress);
            }
            return new NamespaceId(plainUnresolvedAddress);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("'" + plainUnresolvedAddress + "' is not a valid plain address or namespace hex");
        }
    }
}

