/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatUtils {
    private FormatUtils() {
    }

    public static DecimalFormat getDefaultDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#0.000", decimalFormatSymbols);
        format.setGroupingUsed(false);
        return format;
    }

    public static DecimalFormat getDecimalFormat(int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces must be non-negative");
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        StringBuilder builder = new StringBuilder();
        builder.append("#0");
        if (decimalPlaces > 0) {
            builder.append('.');
            char[] zeros = new char[decimalPlaces];
            Arrays.fill(zeros, '0');
            builder.append(zeros);
        }
        DecimalFormat format = new DecimalFormat(builder.toString(), decimalFormatSymbols);
        format.setGroupingUsed(false);
        return format;
    }

    public static String format(double value, int decimalPlaces) {
        DecimalFormat formatter = FormatUtils.getDecimalFormat(decimalPlaces);
        return formatter.format(value);
    }

    public static Duration parseServerDuration(String serverValue) {
        String preprocessedValue = serverValue.replace("'", "").trim();
        Pattern periodPattern = Pattern.compile("([0-9]+)([hdms]+)[:\\s]?");
        Matcher matcher = periodPattern.matcher(preprocessedValue);
        Duration duration = Duration.ofMillis(0L);
        HashSet<String> usedTypes = new HashSet<String>();
        int expected = 0;
        block14: while (matcher.find()) {
            if (expected != matcher.start()) {
                throw new IllegalArgumentException("Duration value format is not recognized.");
            }
            expected = matcher.end();
            int num = Integer.parseInt(matcher.group(1));
            String type = matcher.group(2);
            if (!usedTypes.add(type)) {
                throw new IllegalArgumentException("Duration value format is not recognized.");
            }
            switch (type) {
                case "ms": {
                    duration = duration.plus(Duration.ofMillis(num));
                    continue block14;
                }
                case "s": {
                    duration = duration.plus(Duration.ofSeconds(num));
                    continue block14;
                }
                case "m": {
                    duration = duration.plus(Duration.ofMinutes(num));
                    continue block14;
                }
                case "h": {
                    duration = duration.plus(Duration.ofHours(num));
                    continue block14;
                }
                case "d": {
                    duration = duration.plus(Duration.ofDays(num));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Duration value format is not recognized.");
        }
        if (usedTypes.isEmpty()) {
            throw new IllegalArgumentException("Duration value format is not recognized.");
        }
        return duration;
    }

    public static String toSimpleHex(String serverHex) {
        return serverHex.replace("'", "").replaceAll("^(0x)", "");
    }
}

