/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void propagateVoid(CheckedRunnable runnable) {
        ExceptionUtils.propagateVoid(runnable, RuntimeException::new);
    }

    public static <E extends RuntimeException> void propagateVoid(CheckedRunnable runnable, Function<Exception, E> wrap) {
        ExceptionUtils.propagate(new CheckedRuntimeToCallableAdapter(runnable), wrap);
    }

    public static <T> T propagate(Callable<T> callable) {
        return ExceptionUtils.propagate(callable, RuntimeException::new);
    }

    public static <T, E extends RuntimeException> T propagate(Callable<T> callable, Function<Exception, E> wrap) {
        try {
            return callable.call();
        }
        catch (ExecutionException e) {
            if (RuntimeException.class.isAssignableFrom(e.getCause().getClass())) {
                throw (RuntimeException)e.getCause();
            }
            throw (RuntimeException)wrap.apply(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw (RuntimeException)wrap.apply(e);
        }
    }

    private static class CheckedRuntimeToCallableAdapter
    implements Callable<Void> {
        private final CheckedRunnable runnable;

        public CheckedRuntimeToCallableAdapter(CheckedRunnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Void call() throws Exception {
            this.runnable.call();
            return null;
        }
    }

    public static interface CheckedRunnable {
        public void call() throws Exception;
    }
}

