/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.utils;

import io.nem.symbol.core.utils.StringEncoder;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConvertUtils {
    private static final BigInteger UNSIGNED_LONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

    private ConvertUtils() {
    }

    public static byte[] getBytes(String hexString) {
        try {
            return ConvertUtils.getBytesInternal(hexString);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] getBytesInternal(String hexString) throws DecoderException {
        Hex codec = new Hex();
        String paddedHexString = 0 == hexString.length() % 2 ? hexString : "0" + hexString;
        byte[] encodedBytes = StringEncoder.getBytes(paddedHexString);
        return codec.decode(encodedBytes);
    }

    public static String toHex(byte[] bytes) {
        Hex codec = new Hex();
        byte[] decodedBytes = codec.encode(bytes);
        return StringEncoder.getString(decodedBytes).toUpperCase();
    }

    public static String padHex(String hex, int hexStringSize) {
        Validate.isTrue((hex.length() <= hexStringSize ? 1 : 0) != 0, (String)("Hex " + hex + " size must be at least " + hexStringSize), (Object[])new Object[0]);
        return StringUtils.rightPad((String)hex, (int)hexStringSize, (char)'0');
    }

    public static byte[] fromHexToBytes(String hexString) {
        Hex codec = new Hex();
        try {
            return codec.decode(StringEncoder.getBytes(hexString));
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(hexString + " could not be decoded. " + ExceptionUtils.getMessage((Throwable)e), e);
        }
    }

    public static Pair<String, Integer> xorValues(String originalValue, String newValue) {
        byte[] currentValueBytes = StringEncoder.getBytes(originalValue);
        byte[] newValueBytes = StringEncoder.getBytes(newValue);
        String xorValue = StringEncoder.getString(ConvertUtils.xor(currentValueBytes, newValueBytes));
        return Pair.of((Object)xorValue, (Object)(newValueBytes.length - currentValueBytes.length));
    }

    public static String fromHexToString(String hexString) {
        if (hexString == null) {
            return null;
        }
        return StringEncoder.getString(ConvertUtils.fromHexToBytes(hexString));
    }

    public static String fromStringToHex(String plainText) {
        if (plainText == null) {
            return null;
        }
        return ConvertUtils.toHex(StringEncoder.getBytes(plainText));
    }

    public static String toSize16Hex(BigInteger number) {
        ConvertUtils.validateNotNegative(number);
        return String.format("%016x", number).toUpperCase();
    }

    public static void validateNotNegative(BigInteger number) {
        Validate.notNull((Object)number, (String)"Number must not be null", (Object[])new Object[0]);
        Validate.isTrue((number.compareTo(BigInteger.ZERO) > -1 ? 1 : 0) != 0, (String)("BigInteger '" + number + "' must not be negative"), (Object[])new Object[0]);
    }

    public static void validateNotNegative(long number) {
        Validate.isTrue((number > -1L ? 1 : 0) != 0, (String)("long '" + number + "' must not be negative"), (Object[])new Object[0]);
    }

    public static String toString(BigInteger number) {
        return number.toString();
    }

    public static BigInteger toUnsignedBigInteger(long value) {
        return ConvertUtils.toUnsignedBigInteger(BigInteger.valueOf(value));
    }

    public static BigInteger toUnsignedBigInteger(BigInteger value) {
        return value.and(UNSIGNED_LONG_MASK);
    }

    public static boolean isHexString(String input) {
        if (input == null) {
            return false;
        }
        if (0 != input.length() % 2) {
            return false;
        }
        try {
            ConvertUtils.getBytesInternal(input);
            return true;
        }
        catch (DecoderException e) {
            return false;
        }
    }

    public static void validateIsHexString(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null is not a valid hex");
        }
        if (!ConvertUtils.isHexString(input)) {
            throw new IllegalArgumentException(input + " is not a valid hex");
        }
    }

    public static void validateIsHexString(String input, Integer size) {
        ConvertUtils.validateIsHexString(input);
        if (size != null && input.length() != size.intValue()) {
            throw new IllegalArgumentException(input + " is not an hex of size " + size);
        }
    }

    public static String reverseHexString(String hex) {
        StringBuilder builder = new StringBuilder(hex.length());
        for (int i = hex.length(); i > 1; i -= 2) {
            builder.append(hex, i - 2, i);
        }
        return builder.toString();
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        int length;
        int i;
        byte[] result = new byte[Math.max(b1.length, b2.length)];
        for (i = 0; i < b1.length && i < b2.length; ++i) {
            result[i] = (byte)(b1[i] ^ b2[i]);
        }
        for (i = b2.length; i < b1.length; ++i) {
            result[i] = b1[i];
        }
        for (i = b1.length; i < b2.length; ++i) {
            result[i] = b2[i];
        }
        for (length = result.length; length > 0 && result[length - 1] == 0; --length) {
        }
        if (length < result.length) {
            return Arrays.copyOf(result, length);
        }
        return result;
    }
}

