/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.math;

import io.nem.symbol.core.math.Matrix;
import io.nem.symbol.core.math.MatrixElement;
import io.nem.symbol.core.math.MatrixNonZeroElementRowIterator;
import io.nem.symbol.core.utils.FormatUtils;
import java.text.DecimalFormat;
import java.util.Arrays;

public class SparseMatrix
extends Matrix {
    private static final double REALLOC_MULTIPLIER = 1.6;
    private final int numRows;
    private final int initialCapacityPerRow;
    private double[][] values = null;
    private int[][] cols = null;
    private int[] maxIndices = null;

    public SparseMatrix(int numRows, int numCols, int initialCapacityPerRow) {
        super(numRows, numCols);
        this.numRows = numRows;
        this.initialCapacityPerRow = initialCapacityPerRow;
        this.values = new double[numRows][];
        this.cols = new int[numRows][];
        this.maxIndices = new int[numRows];
        for (int i = 0; i < numRows; ++i) {
            this.values[i] = new double[initialCapacityPerRow];
            this.cols[i] = new int[initialCapacityPerRow];
            this.maxIndices[i] = 0;
        }
    }

    private static String formatEntry(int row, int col, double value) {
        DecimalFormat format = FormatUtils.getDefaultDecimalFormat();
        return String.format("%s(%d, %d) -> %s", System.lineSeparator(), row, col, format.format(value));
    }

    @Override
    protected final Matrix create(int numRows, int numCols) {
        return new SparseMatrix(numRows, numCols, this.initialCapacityPerRow);
    }

    @Override
    protected final double getAtUnchecked(int row, int col) {
        int i = Arrays.binarySearch(this.cols[row], 0, this.maxIndices[row], col);
        return i < 0 ? 0.0 : this.values[row][i];
    }

    @Override
    protected final void setAtUnchecked(int row, int col, double val) {
        int i;
        if (val == 0.0) {
            for (int i2 = 0; i2 < this.maxIndices[row]; ++i2) {
                if (this.cols[row][i2] != col) continue;
                this.remove(row, i2);
                return;
            }
            return;
        }
        if (this.maxIndices[row] == 0) {
            this.cols[row][0] = col;
            this.values[row][0] = val;
            int n = row;
            this.maxIndices[n] = this.maxIndices[n] + 1;
            return;
        }
        int maxIndex = this.maxIndices[row];
        for (i = 0; i < maxIndex && this.cols[row][i] < col; ++i) {
        }
        if (i == maxIndex) {
            if (maxIndex == this.cols[row].length) {
                this.reallocate(row);
            }
            this.cols[row][i] = col;
            this.values[row][i] = val;
            int n = row;
            this.maxIndices[n] = this.maxIndices[n] + 1;
            return;
        }
        if (this.cols[row][i] == col) {
            this.values[row][i] = val;
            return;
        }
        this.insertColumn(row, col, val, i);
    }

    private void insertColumn(int row, int col, double val, int i) {
        if (this.maxIndices[row] == this.cols[row].length) {
            this.reallocate(row);
        }
        System.arraycopy(this.cols[row], i, this.cols[row], i + 1, this.maxIndices[row] - i);
        System.arraycopy(this.values[row], i, this.values[row], i + 1, this.maxIndices[row] - i);
        this.cols[row][i] = col;
        this.values[row][i] = val;
        int n = row;
        this.maxIndices[n] = this.maxIndices[n] + 1;
    }

    @Override
    protected final void forEach(Matrix.ElementVisitorFunction func) {
        boolean[] copied = new boolean[1];
        for (int i = 0; i < this.numRows; ++i) {
            int iCopy = i;
            double[] rowValues = this.values[i];
            int[] rowCols = this.cols[i];
            int size = this.maxIndices[i];
            for (int j = 0; j < size; ++j) {
                int jCopy = j;
                copied[0] = false;
                func.visit(i, rowCols[j], rowValues[j], v -> {
                    if (0.0 == v) {
                        copied[0] = this.remove(iCopy, jCopy);
                    } else {
                        rowValues[jCopy] = v;
                    }
                });
                if (!copied[0]) continue;
                size = this.maxIndices[i];
                --j;
            }
        }
    }

    @Override
    public final void forEach(Matrix.ReadOnlyElementVisitorFunction func) {
        for (int i = 0; i < this.numRows; ++i) {
            double[] rowValues = this.values[i];
            int[] rowCols = this.cols[i];
            int size = this.maxIndices[i];
            for (int j = 0; j < size; ++j) {
                func.visit(i, rowCols[j], rowValues[j]);
            }
        }
    }

    @Override
    public MatrixNonZeroElementRowIterator getNonZeroElementRowIterator(final int row) {
        final int[] rowCols = this.cols[row];
        final double[] rowValues = this.values[row];
        final int maxIndex = this.maxIndices[row];
        return new MatrixNonZeroElementRowIterator(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < maxIndex;
            }

            @Override
            public MatrixElement next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("index out of range");
                }
                return new MatrixElement(row, rowCols[this.index], rowValues[this.index++]);
            }
        };
    }

    public int getNonZeroColumnCount(int row) {
        return this.maxIndices[row];
    }

    public int getRowCapacity(int row) {
        return this.cols[row].length;
    }

    private boolean remove(int row, int colIndex) {
        boolean copied = false;
        int lastIndex = this.maxIndices[row] - 1;
        if (lastIndex > 0 && lastIndex != colIndex) {
            System.arraycopy(this.cols[row], colIndex + 1, this.cols[row], colIndex, lastIndex - colIndex);
            System.arraycopy(this.values[row], colIndex + 1, this.values[row], colIndex, lastIndex - colIndex);
            copied = true;
        }
        if (lastIndex >= 0) {
            this.cols[row][lastIndex] = 0;
            this.values[row][lastIndex] = 0.0;
        }
        int n = row;
        this.maxIndices[n] = this.maxIndices[n] - 1;
        return copied;
    }

    private void reallocate(int row) {
        int size = this.cols[row].length;
        int newSize = (int)Math.ceil(1.6 * (double)size);
        int[] newCols = new int[newSize];
        double[] newValues = new double[newSize];
        System.arraycopy(this.cols[row], 0, newCols, 0, size);
        System.arraycopy(this.values[row], 0, newValues, 0, size);
        this.cols[row] = newCols;
        this.values[row] = newValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("[%d x %d]", this.getRowCount(), this.getColumnCount()));
        this.forEach((int r, int c, double v) -> builder.append(SparseMatrix.formatEntry(r, c, v)));
        return builder.toString();
    }

    public int getNumEntries() {
        int numEntries = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            numEntries += this.maxIndices[i];
        }
        return numEntries;
    }
}

