/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.math;

import io.nem.symbol.core.math.Matrix;
import io.nem.symbol.core.math.MatrixElement;
import io.nem.symbol.core.math.MatrixNonZeroElementRowIterator;
import io.nem.symbol.core.utils.FormatUtils;
import java.text.DecimalFormat;
import java.util.function.DoubleConsumer;

public final class DenseMatrix
extends Matrix {
    private final int numCols;
    private final double[] values;

    public DenseMatrix(int rows, int cols) {
        super(rows, cols);
        this.numCols = cols;
        this.values = new double[this.getElementCount()];
    }

    public DenseMatrix(int rows, int cols, double[] values) {
        super(rows, cols);
        if (values.length != this.getElementCount()) {
            throw new IllegalArgumentException("incompatible number of values");
        }
        this.numCols = cols;
        this.values = values;
    }

    public double[] getRaw() {
        return this.values;
    }

    @Override
    protected final Matrix create(int numRows, int numCols) {
        return new DenseMatrix(numRows, numCols);
    }

    @Override
    protected final double getAtUnchecked(int row, int col) {
        return this.values[row * this.numCols + col];
    }

    @Override
    protected final void setAtUnchecked(int row, int col, double val) {
        this.values[row * this.numCols + col] = val;
    }

    @Override
    protected final void forEach(Matrix.ElementVisitorFunction func) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                SetWrapper setWrapper = new SetWrapper(i, j);
                func.visit(i, j, this.getAtUnchecked(i, j), setWrapper);
            }
        }
    }

    @Override
    public MatrixNonZeroElementRowIterator getNonZeroElementRowIterator(final int row) {
        return new MatrixNonZeroElementRowIterator(){
            private int index;

            @Override
            public boolean hasNext() {
                for (int i = this.index; i < DenseMatrix.this.getColumnCount(); ++i) {
                    if (DenseMatrix.this.getAt(row, i) == 0.0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public MatrixElement next() {
                while (this.index < DenseMatrix.this.getColumnCount()) {
                    if (DenseMatrix.this.getAt(row, this.index++) == 0.0) continue;
                    return new MatrixElement(row, this.index - 1, DenseMatrix.this.getAt(row, this.index - 1));
                }
                throw new IndexOutOfBoundsException("index out of range");
            }
        };
    }

    public String toString() {
        DecimalFormat format = FormatUtils.getDefaultDecimalFormat();
        StringBuilder builder = new StringBuilder();
        this.forEach((int r, int c, double v) -> {
            if (0 != r && 0 == c) {
                builder.append(System.lineSeparator());
            }
            if (0 != c) {
                builder.append(" ");
            }
            builder.append(format.format(v));
        });
        return builder.toString();
    }

    class SetWrapper
    implements DoubleConsumer {
        final int i;
        final int j;

        SetWrapper(int i, int j) {
            this.i = i;
            this.j = j;
        }

        @Override
        public void accept(double value) {
            DenseMatrix.this.setAtUnchecked(this.i, this.j, value);
        }
    }
}

