/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto.ed25519.arithmetic;

import io.nem.symbol.core.crypto.ed25519.arithmetic.CoordinateSystem;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519Field;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519FieldElement;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519Group;
import io.nem.symbol.core.utils.ByteUtils;
import java.io.Serializable;
import java.util.Objects;

public class Ed25519GroupElement
implements Serializable {
    private final CoordinateSystem coordinateSystem;
    private final Ed25519FieldElement x;
    private final Ed25519FieldElement y;
    private final Ed25519FieldElement z;
    private final Ed25519FieldElement t;
    private Ed25519GroupElement[][] precomputedForSingle;
    private Ed25519GroupElement[] precomputedForDouble;

    public Ed25519GroupElement(CoordinateSystem coordinateSystem, Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement z, Ed25519FieldElement t) {
        this.coordinateSystem = coordinateSystem;
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    public static Ed25519GroupElement affine(Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement z) {
        return new Ed25519GroupElement(CoordinateSystem.AFFINE, x, y, z, null);
    }

    public static Ed25519GroupElement p2(Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement z) {
        return new Ed25519GroupElement(CoordinateSystem.P2, x, y, z, null);
    }

    public static Ed25519GroupElement p3(Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement z, Ed25519FieldElement t) {
        return new Ed25519GroupElement(CoordinateSystem.P3, x, y, z, t);
    }

    public static Ed25519GroupElement p1xp1(Ed25519FieldElement x, Ed25519FieldElement y, Ed25519FieldElement z, Ed25519FieldElement t) {
        return new Ed25519GroupElement(CoordinateSystem.P1xP1, x, y, z, t);
    }

    public static Ed25519GroupElement precomputed(Ed25519FieldElement yPlusx, Ed25519FieldElement yMinusx, Ed25519FieldElement xy2d) {
        return new Ed25519GroupElement(CoordinateSystem.PRECOMPUTED, yPlusx, yMinusx, xy2d, null);
    }

    public static Ed25519GroupElement cached(Ed25519FieldElement yPlusX, Ed25519FieldElement yMinusX, Ed25519FieldElement z, Ed25519FieldElement t2D) {
        return new Ed25519GroupElement(CoordinateSystem.CACHED, yPlusX, yMinusX, z, t2D);
    }

    private static byte[] toRadix16(Ed25519EncodedFieldElement encoded) {
        int i;
        byte[] a = encoded.getRaw();
        byte[] e = new byte[64];
        for (i = 0; i < 32; ++i) {
            e[2 * i] = (byte)(a[i] & 0xF);
            e[2 * i + 1] = (byte)(a[i] >> 4 & 0xF);
        }
        int carry = 0;
        i = 0;
        while (i < 63) {
            int n = i;
            e[n] = (byte)(e[n] + carry);
            carry = e[i] + 8;
            int n2 = i++;
            e[n2] = (byte)(e[n2] - ((carry >>= 4) << 4));
        }
        e[63] = (byte)(e[63] + carry);
        return e;
    }

    private static byte[] slide(Ed25519EncodedFieldElement encoded) {
        int i;
        byte[] a = encoded.getRaw();
        byte[] r = new byte[256];
        for (i = 0; i < 256; ++i) {
            r[i] = (byte)(1 & a[i >> 3] >> (i & 7));
        }
        block1: for (i = 0; i < 256; ++i) {
            if (r[i] == 0) continue;
            block2: for (int b = 1; b <= 6 && i + b < 256; ++b) {
                if (r[i + b] == 0) continue;
                if (r[i] + (r[i + b] << b) <= 15) {
                    int n = i;
                    r[n] = (byte)(r[n] + (r[i + b] << b));
                    r[i + b] = 0;
                    continue;
                }
                if (r[i] - (r[i + b] << b) < -15) continue block1;
                int n = i;
                r[n] = (byte)(r[n] - (r[i + b] << b));
                for (int k = i + b; k < 256; ++k) {
                    if (r[k] == 0) {
                        r[k] = 1;
                        continue block2;
                    }
                    r[k] = 0;
                }
            }
        }
        return r;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public Ed25519FieldElement getX() {
        return this.x;
    }

    public Ed25519FieldElement getY() {
        return this.y;
    }

    public Ed25519FieldElement getZ() {
        return this.z;
    }

    public Ed25519FieldElement getT() {
        return this.t;
    }

    public boolean isPrecomputedForDoubleScalarMultiplication() {
        return null != this.precomputedForDouble;
    }

    public Ed25519GroupElement[][] getPrecomputedForSingle() {
        return this.precomputedForSingle;
    }

    public Ed25519GroupElement[] getPrecomputedForDouble() {
        return this.precomputedForDouble;
    }

    public Ed25519EncodedGroupElement encode() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement inverse = this.z.invert();
                Ed25519FieldElement xElement = this.x.multiply(inverse);
                Ed25519FieldElement yElement = this.y.multiply(inverse);
                byte[] s = yElement.encode().getRaw();
                int n = s.length - 1;
                s[n] = (byte)(s[n] | (xElement.isNegative() ? -128 : 0));
                return new Ed25519EncodedGroupElement(s);
            }
        }
        return this.toP2().encode();
    }

    public Ed25519GroupElement toP2() {
        return this.toCoordinateSystem(CoordinateSystem.P2);
    }

    public Ed25519GroupElement toP3() {
        return this.toCoordinateSystem(CoordinateSystem.P3);
    }

    public Ed25519GroupElement toCached() {
        return this.toCoordinateSystem(CoordinateSystem.CACHED);
    }

    private Ed25519GroupElement toCoordinateSystem(CoordinateSystem newCoordinateSystem) {
        switch (this.coordinateSystem) {
            case P2: {
                if (newCoordinateSystem == CoordinateSystem.P2) {
                    return Ed25519GroupElement.p2(this.x, this.y, this.z);
                }
                throw new IllegalArgumentException();
            }
            case P3: {
                switch (newCoordinateSystem) {
                    case P2: {
                        return Ed25519GroupElement.p2(this.x, this.y, this.z);
                    }
                    case P3: {
                        return Ed25519GroupElement.p3(this.x, this.y, this.z, this.t);
                    }
                    case CACHED: {
                        return Ed25519GroupElement.cached(this.y.add(this.x), this.y.subtract(this.x), this.z, this.t.multiply(Ed25519Field.D_Times_TWO));
                    }
                }
                throw new IllegalArgumentException();
            }
            case P1xP1: {
                switch (newCoordinateSystem) {
                    case P2: {
                        return Ed25519GroupElement.p2(this.x.multiply(this.t), this.y.multiply(this.z), this.z.multiply(this.t));
                    }
                    case P3: {
                        return Ed25519GroupElement.p3(this.x.multiply(this.t), this.y.multiply(this.z), this.z.multiply(this.t), this.x.multiply(this.y));
                    }
                    case P1xP1: {
                        return Ed25519GroupElement.p1xp1(this.x, this.y, this.z, this.t);
                    }
                }
                throw new IllegalArgumentException();
            }
            case PRECOMPUTED: {
                if (newCoordinateSystem == CoordinateSystem.PRECOMPUTED) {
                    return Ed25519GroupElement.precomputed(this.x, this.y, this.z);
                }
                throw new IllegalArgumentException();
            }
            case CACHED: {
                if (newCoordinateSystem == CoordinateSystem.CACHED) {
                    return Ed25519GroupElement.cached(this.x, this.y, this.z, this.t);
                }
                throw new IllegalArgumentException();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void precomputeForScalarMultiplication() {
        if (null != this.precomputedForSingle) {
            return;
        }
        Ed25519GroupElement bi = this;
        this.precomputedForSingle = new Ed25519GroupElement[32][8];
        for (int i = 0; i < 32; ++i) {
            Ed25519GroupElement bij = bi;
            for (int j = 0; j < 8; ++j) {
                Ed25519FieldElement inverse = bij.z.invert();
                Ed25519FieldElement xElement = bij.x.multiply(inverse);
                Ed25519FieldElement yElement = bij.y.multiply(inverse);
                this.precomputedForSingle[i][j] = Ed25519GroupElement.precomputed(yElement.add(xElement), yElement.subtract(xElement), xElement.multiply(yElement).multiply(Ed25519Field.D_Times_TWO));
                bij = bij.add(bi.toCached()).toP3();
            }
            for (int k = 0; k < 8; ++k) {
                bi = bi.add(bi.toCached()).toP3();
            }
        }
    }

    public void precomputeForDoubleScalarMultiplication() {
        if (null != this.precomputedForDouble) {
            return;
        }
        Ed25519GroupElement bi = this;
        this.precomputedForDouble = new Ed25519GroupElement[8];
        for (int i = 0; i < 8; ++i) {
            Ed25519FieldElement inverse = bi.z.invert();
            Ed25519FieldElement xElement = bi.x.multiply(inverse);
            Ed25519FieldElement yElement = bi.y.multiply(inverse);
            this.precomputedForDouble[i] = Ed25519GroupElement.precomputed(yElement.add(xElement), yElement.subtract(xElement), xElement.multiply(yElement).multiply(Ed25519Field.D_Times_TWO));
            bi = this.add(this.add(bi.toCached()).toP3().toCached()).toP3();
        }
    }

    public Ed25519GroupElement dbl() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement xSquare = this.x.square();
                Ed25519FieldElement ySquare = this.y.square();
                Ed25519FieldElement b = this.z.squareAndDouble();
                Ed25519FieldElement a = this.x.add(this.y);
                Ed25519FieldElement aSquare = a.square();
                Ed25519FieldElement ySquarePlusXSquare = ySquare.add(xSquare);
                Ed25519FieldElement ySquareMinusXSquare = ySquare.subtract(xSquare);
                return Ed25519GroupElement.p1xp1(aSquare.subtract(ySquarePlusXSquare), ySquarePlusXSquare, ySquareMinusXSquare, b.subtract(ySquareMinusXSquare));
            }
        }
        throw new UnsupportedOperationException();
    }

    private Ed25519GroupElement precomputedAdd(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.PRECOMPUTED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement yPlusX = this.y.add(this.x);
        Ed25519FieldElement yMinusX = this.y.subtract(this.x);
        Ed25519FieldElement a = yPlusX.multiply(g.x);
        Ed25519FieldElement b = yMinusX.multiply(g.y);
        Ed25519FieldElement c = g.z.multiply(this.t);
        Ed25519FieldElement d = this.z.add(this.z);
        return Ed25519GroupElement.p1xp1(a.subtract(b), a.add(b), d.add(c), d.subtract(c));
    }

    private Ed25519GroupElement precomputedSubtract(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.PRECOMPUTED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement yPlusX = this.y.add(this.x);
        Ed25519FieldElement yMinusX = this.y.subtract(this.x);
        Ed25519FieldElement a = yPlusX.multiply(g.y);
        Ed25519FieldElement b = yMinusX.multiply(g.x);
        Ed25519FieldElement c = g.z.multiply(this.t);
        Ed25519FieldElement d = this.z.add(this.z);
        return Ed25519GroupElement.p1xp1(a.subtract(b), a.add(b), d.subtract(c), d.add(c));
    }

    public Ed25519GroupElement add(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.CACHED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement yPlusX = this.y.add(this.x);
        Ed25519FieldElement yMinusX = this.y.subtract(this.x);
        Ed25519FieldElement a = yPlusX.multiply(g.x);
        Ed25519FieldElement b = yMinusX.multiply(g.y);
        Ed25519FieldElement c = g.t.multiply(this.t);
        Ed25519FieldElement zSquare = this.z.multiply(g.z);
        Ed25519FieldElement d = zSquare.add(zSquare);
        return Ed25519GroupElement.p1xp1(a.subtract(b), a.add(b), d.add(c), d.subtract(c));
    }

    public Ed25519GroupElement subtract(Ed25519GroupElement g) {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        if (g.coordinateSystem != CoordinateSystem.CACHED) {
            throw new IllegalArgumentException();
        }
        Ed25519FieldElement yPlusX = this.y.add(this.x);
        Ed25519FieldElement yMinusX = this.y.subtract(this.x);
        Ed25519FieldElement a = yPlusX.multiply(g.y);
        Ed25519FieldElement b = yMinusX.multiply(g.x);
        Ed25519FieldElement c = g.t.multiply(this.t);
        Ed25519FieldElement zSquare = this.z.multiply(g.z);
        Ed25519FieldElement d = zSquare.add(zSquare);
        return Ed25519GroupElement.p1xp1(a.subtract(b), a.add(b), d.subtract(c), d.add(c));
    }

    public Ed25519GroupElement negate() {
        if (this.coordinateSystem != CoordinateSystem.P3) {
            throw new UnsupportedOperationException();
        }
        return Ed25519Group.ZERO_P3.subtract(this.toCached()).toP3();
    }

    public int hashCode() {
        return this.encode().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ed25519GroupElement)) {
            return false;
        }
        Ed25519GroupElement ge = (Ed25519GroupElement)obj;
        if (!this.coordinateSystem.equals((Object)ge.coordinateSystem)) {
            try {
                ge = ge.toCoordinateSystem(this.coordinateSystem);
            }
            catch (Exception e) {
                return false;
            }
        }
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                if (this.z.equals(ge.z)) {
                    return this.x.equals(ge.x) && this.y.equals(ge.y);
                }
                Ed25519FieldElement x1 = this.x.multiply(ge.z);
                Ed25519FieldElement y1 = this.y.multiply(ge.z);
                Ed25519FieldElement x2 = ge.x.multiply(this.z);
                Ed25519FieldElement y2 = ge.y.multiply(this.z);
                return x1.equals(x2) && y1.equals(y2);
            }
            case P1xP1: {
                return this.toP2().equals(ge);
            }
            case PRECOMPUTED: {
                return this.x.equals(ge.x) && this.y.equals(ge.y) && this.z.equals(ge.z);
            }
            case CACHED: {
                if (this.z.equals(ge.z)) {
                    return this.x.equals(ge.x) && this.y.equals(ge.y) && this.t.equals(ge.t);
                }
                Ed25519FieldElement x3 = this.x.multiply(ge.z);
                Ed25519FieldElement y3 = this.y.multiply(ge.z);
                Ed25519FieldElement t3 = this.t.multiply(ge.z);
                Ed25519FieldElement x4 = ge.x.multiply(this.z);
                Ed25519FieldElement y4 = ge.y.multiply(this.z);
                Ed25519FieldElement t4 = ge.t.multiply(this.z);
                return x3.equals(x4) && y3.equals(y4) && t3.equals(t4);
            }
        }
        return false;
    }

    private Ed25519GroupElement cmov(Ed25519GroupElement u, int b) {
        int i;
        Ed25519GroupElement ret = null;
        for (i = 0; i < b; ++i) {
            ret = u;
        }
        for (i = 0; i < 1 - b; ++i) {
            ret = this;
        }
        return ret;
    }

    private Ed25519GroupElement nullSafeCmov(Ed25519GroupElement u, int b) {
        Ed25519GroupElement ret = this.cmov(u, b);
        if (ret == null) {
            throw new IllegalStateException("Ed25519GroupElement " + Objects.toString(u, "NULL") + " and argument " + b + " resolved a null cmov");
        }
        return ret;
    }

    private Ed25519GroupElement select(int pos, int b) {
        int bNegative = ByteUtils.isNegativeConstantTime(b);
        int bAbs = b - ((-bNegative & b) << 1);
        Ed25519GroupElement tElement = Ed25519Group.ZERO_PRECOMPUTED.nullSafeCmov(this.precomputedForSingle[pos][0], ByteUtils.isEqualConstantTime(bAbs, 1)).nullSafeCmov(this.precomputedForSingle[pos][1], ByteUtils.isEqualConstantTime(bAbs, 2)).nullSafeCmov(this.precomputedForSingle[pos][2], ByteUtils.isEqualConstantTime(bAbs, 3)).nullSafeCmov(this.precomputedForSingle[pos][3], ByteUtils.isEqualConstantTime(bAbs, 4)).nullSafeCmov(this.precomputedForSingle[pos][4], ByteUtils.isEqualConstantTime(bAbs, 5)).nullSafeCmov(this.precomputedForSingle[pos][5], ByteUtils.isEqualConstantTime(bAbs, 6)).nullSafeCmov(this.precomputedForSingle[pos][6], ByteUtils.isEqualConstantTime(bAbs, 7)).nullSafeCmov(this.precomputedForSingle[pos][7], ByteUtils.isEqualConstantTime(bAbs, 8));
        Ed25519GroupElement tMinus = Ed25519GroupElement.precomputed(tElement.y, tElement.x, tElement.z.negate());
        return tElement.nullSafeCmov(tMinus, bNegative);
    }

    public Ed25519GroupElement scalarMultiply(Ed25519EncodedFieldElement a) {
        Ed25519GroupElement g;
        int i;
        byte[] e = Ed25519GroupElement.toRadix16(a);
        Ed25519GroupElement h = Ed25519Group.ZERO_P3;
        for (i = 1; i < 64; i += 2) {
            g = this.select(i / 2, e[i]);
            h = h.precomputedAdd(g).toP3();
        }
        h = h.dbl().toP2().dbl().toP2().dbl().toP2().dbl().toP3();
        for (i = 0; i < 64; i += 2) {
            g = this.select(i / 2, e[i]);
            h = h.precomputedAdd(g).toP3();
        }
        return h;
    }

    public Ed25519GroupElement doubleScalarMultiplyVariableTime(Ed25519GroupElement aGroupElement, Ed25519EncodedFieldElement a, Ed25519EncodedFieldElement b) {
        int i;
        byte[] aSlide = Ed25519GroupElement.slide(a);
        byte[] bSlide = Ed25519GroupElement.slide(b);
        Ed25519GroupElement r = Ed25519Group.ZERO_P2;
        for (i = 255; i >= 0 && aSlide[i] == 0 && bSlide[i] == 0; --i) {
        }
        while (i >= 0) {
            Ed25519GroupElement tElement = r.dbl();
            if (aSlide[i] > 0) {
                tElement = tElement.toP3().precomputedSubtract(aGroupElement.precomputedForDouble[aSlide[i] / 2]);
            } else if (aSlide[i] < 0) {
                tElement = tElement.toP3().precomputedAdd(aGroupElement.precomputedForDouble[-aSlide[i] / 2]);
            }
            if (bSlide[i] > 0) {
                tElement = tElement.toP3().precomputedAdd(this.precomputedForDouble[bSlide[i] / 2]);
            } else if (bSlide[i] < 0) {
                tElement = tElement.toP3().precomputedSubtract(this.precomputedForDouble[-bSlide[i] / 2]);
            }
            r = tElement.toP2();
            --i;
        }
        return r;
    }

    public boolean satisfiesCurveEquation() {
        switch (this.coordinateSystem) {
            case P2: 
            case P3: {
                Ed25519FieldElement inverse = this.z.invert();
                Ed25519FieldElement xElement = this.x.multiply(inverse);
                Ed25519FieldElement yElement = this.y.multiply(inverse);
                Ed25519FieldElement xSquare = xElement.square();
                Ed25519FieldElement ySquare = yElement.square();
                Ed25519FieldElement dXSquareYSquare = Ed25519Field.D.multiply(xSquare).multiply(ySquare);
                return Ed25519Field.ONE.add(dXSquareYSquare).add(xSquare).equals(ySquare);
            }
        }
        return this.toP2().satisfiesCurveEquation();
    }

    public String toString() {
        return String.format("X=%s\nY=%s\nZ=%s\nT=%s\n", this.x.toString(), this.y.toString(), this.z.toString(), this.t.toString());
    }
}

