/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto.ed25519;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import java.util.Arrays;

public class Ed25519Utils {
    private Ed25519Utils() {
    }

    public static Ed25519EncodedFieldElement prepareForScalarMultiply(PrivateKey key) {
        byte[] hash = Hashes.sha512(new byte[][]{key.getBytes()});
        byte[] a = Arrays.copyOfRange(hash, 0, 32);
        a[31] = (byte)(a[31] & 0x7F);
        a[31] = (byte)(a[31] | 0x40);
        a[0] = (byte)(a[0] & 0xF8);
        return new Ed25519EncodedFieldElement(a);
    }
}

