/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto.ed25519;

import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.KeyGenerator;
import io.nem.symbol.core.crypto.KeyPair;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.crypto.ed25519.Ed25519Utils;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519EncodedFieldElement;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519Group;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519GroupElement;

public class Ed25519KeyGenerator
implements KeyGenerator {
    @Override
    public KeyPair generateKeyPair() {
        PrivateKey privateKey = PrivateKey.generateRandom();
        return KeyPair.fromPrivate(privateKey, CryptoEngines.ed25519Engine());
    }

    @Override
    public PublicKey derivePublicKey(PrivateKey privateKey) {
        Ed25519EncodedFieldElement a = Ed25519Utils.prepareForScalarMultiply(privateKey);
        Ed25519GroupElement pubKey = Ed25519Group.BASE_POINT.scalarMultiply(a);
        return new PublicKey(pubKey.encode().getRaw());
    }
}

