/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto.ed25519;

import io.nem.symbol.core.crypto.BlockCipher;
import io.nem.symbol.core.crypto.CryptoException;
import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.crypto.KeyPair;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import io.nem.symbol.core.crypto.ed25519.AESGCM;
import io.nem.symbol.core.crypto.ed25519.AuthenticatedCipherText;
import io.nem.symbol.core.crypto.ed25519.Ed25519Utils;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519EncodedGroupElement;
import io.nem.symbol.core.crypto.ed25519.arithmetic.Ed25519GroupElement;
import io.nem.symbol.core.utils.ArrayUtils;
import java.util.Arrays;

public class Ed25519BlockCipher
implements BlockCipher {
    private final KeyPair senderKeyPair;
    private final KeyPair recipientKeyPair;

    public Ed25519BlockCipher(KeyPair senderKeyPair, KeyPair recipientKeyPair) {
        this.senderKeyPair = senderKeyPair;
        this.recipientKeyPair = recipientKeyPair;
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        return this.encrypt(plainText, AESGCM.generateIV());
    }

    public byte[] encrypt(byte[] plainText, byte[] ivData) {
        AuthenticatedCipherText encryptResult = this.encode(plainText, ivData);
        byte[] authTag = encryptResult.getAuthenticationTag();
        byte[] cipherText = encryptResult.getCipherText();
        return ArrayUtils.concat(authTag, encryptResult.getIv(), cipherText);
    }

    public AuthenticatedCipherText encode(byte[] plainText, byte[] ivData) {
        byte[] sharedKey = Ed25519BlockCipher.getSharedKey(this.senderKeyPair.getPrivateKey(), this.recipientKeyPair.getPublicKey());
        return AESGCM.encrypt(sharedKey, ivData, plainText);
    }

    @Override
    public byte[] decrypt(byte[] input) {
        if (input == null) {
            throw new CryptoException("Cannot decrypt. Input is required.");
        }
        int minSize = 28;
        if (input.length < minSize) {
            throw new CryptoException("Cannot decrypt input. Size is " + input.length + " when at least " + minSize + " is expected.");
        }
        byte[] authTag = Arrays.copyOfRange(input, 0, 16);
        byte[] ivData = Arrays.copyOfRange(input, 16, 28);
        byte[] cypherText = Arrays.copyOfRange(input, 28, input.length);
        return this.decode(authTag, ivData, cypherText);
    }

    public byte[] decode(byte[] authTag, byte[] ivData, byte[] cypherText) {
        byte[] sharedKey = Ed25519BlockCipher.getSharedKey(this.recipientKeyPair.getPrivateKey(), this.senderKeyPair.getPublicKey());
        return AESGCM.decrypt(sharedKey, ivData, cypherText, authTag);
    }

    public static byte[] getSharedKey(PrivateKey privateKey, PublicKey publicKey) {
        return Hashes.sha256ForSharedKey(Ed25519BlockCipher.getSharedSecret(privateKey, publicKey));
    }

    public static byte[] getSharedSecret(PrivateKey privateKey, PublicKey publicKey) {
        Ed25519GroupElement senderA = new Ed25519EncodedGroupElement(publicKey.getBytes()).decode();
        senderA.precomputeForScalarMultiplication();
        return senderA.scalarMultiply(Ed25519Utils.prepareForScalarMultiply(privateKey)).encode().getRaw();
    }
}

