/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto.ed25519;

import io.nem.symbol.core.crypto.CryptoException;
import io.nem.symbol.core.crypto.ed25519.AuthenticatedCipherText;
import io.nem.symbol.sdk.infrastructure.RandomUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESGCM {
    public static final int IV_BIT_LENGTH = 96;
    public static final int AUTH_TAG_BIT_LENGTH = 128;
    public static final int IV_LENGTH = 12;
    public static final int TAG_LENGTH = 16;

    public static byte[] generateIV() {
        return RandomUtils.generateRandomBytes(12);
    }

    private static GCMBlockCipher createAESGCMCipher(byte[] secretKey, boolean forEncryption, byte[] iv) {
        AESEngine cipher = AESGCM.createCipher(secretKey, forEncryption);
        GCMBlockCipher gcm = new GCMBlockCipher((BlockCipher)cipher);
        KeyParameter keyParam = new KeyParameter(secretKey);
        ParametersWithIV params = new ParametersWithIV((CipherParameters)keyParam, iv);
        gcm.init(forEncryption, (CipherParameters)params);
        return gcm;
    }

    private static AESEngine createCipher(byte[] secretKey, boolean forEncryption) {
        AESEngine cipher = new AESEngine();
        KeyParameter cipherParams = new KeyParameter(secretKey);
        cipher.init(forEncryption, (CipherParameters)cipherParams);
        return cipher;
    }

    public static AuthenticatedCipherText encrypt(byte[] secretKey, byte[] iv, byte[] plainText) throws RuntimeException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, true, iv);
        int outputLength = cipher.getOutputSize(plainText.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(plainText, 0, plainText.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException("Could Not Generate GCM Authentication: " + ExceptionUtils.getMessage((Throwable)e), e);
        }
        int authTagLength = 16;
        byte[] cipherText = new byte[outputOffset - authTagLength];
        byte[] authTag = new byte[authTagLength];
        System.arraycopy(output, 0, cipherText, 0, cipherText.length);
        System.arraycopy(output, outputOffset - authTagLength, authTag, 0, authTag.length);
        return new AuthenticatedCipherText(cipherText, authTag, iv);
    }

    public static byte[] decrypt(byte[] secretKey, byte[] iv, byte[] cipherText, byte[] authTag) throws RuntimeException {
        GCMBlockCipher cipher = AESGCM.createAESGCMCipher(secretKey, false, iv);
        byte[] input = new byte[cipherText.length + authTag.length];
        System.arraycopy(cipherText, 0, input, 0, cipherText.length);
        System.arraycopy(authTag, 0, input, cipherText.length, authTag.length);
        int outputLength = cipher.getOutputSize(input.length);
        byte[] output = new byte[outputLength];
        int outputOffset = cipher.processBytes(input, 0, input.length, output, 0);
        try {
            outputOffset += cipher.doFinal(output, outputOffset);
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException("Could decrypt value: " + ExceptionUtils.getMessage((Throwable)e), e);
        }
        return output;
    }

    private AESGCM() {
    }
}

