/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.utils.ArrayUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import java.math.BigInteger;
import java.util.Arrays;

public class Signature {
    private static final BigInteger MAXIMUM_VALUE = BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE);
    private final byte[] r;
    private final byte[] s;

    public Signature(BigInteger r, BigInteger s) {
        if (0 < r.compareTo(MAXIMUM_VALUE) || 0 < s.compareTo(MAXIMUM_VALUE)) {
            throw new IllegalArgumentException("r and s must fit into 32 bytes");
        }
        this.r = ArrayUtils.toByteArray(r, 32);
        this.s = ArrayUtils.toByteArray(s, 32);
    }

    public Signature(byte[] bytes) {
        if (64 != bytes.length) {
            throw new IllegalArgumentException("binary signature representation must be 64 bytes");
        }
        byte[][] parts = ArrayUtils.split(bytes, 32);
        this.r = parts[0];
        this.s = parts[1];
    }

    public Signature(byte[] r, byte[] s) {
        if (32 != r.length || 32 != s.length) {
            throw new IllegalArgumentException("binary signature representation of r and s must both have 32 bytes length");
        }
        this.r = r;
        this.s = s;
    }

    public BigInteger getR() {
        return ArrayUtils.toBigInteger(this.r);
    }

    public byte[] getBinaryR() {
        return this.r;
    }

    public BigInteger getS() {
        return ArrayUtils.toBigInteger(this.s);
    }

    public byte[] getBinaryS() {
        return this.s;
    }

    public byte[] getBytes() {
        return ArrayUtils.concat(this.r, this.s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Arrays.equals(this.r, signature.r) && Arrays.equals(this.s, signature.s);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.r);
        result = 31 * result + Arrays.hashCode(this.s);
        return result;
    }

    public String toString() {
        return ConvertUtils.toHex(this.getBytes());
    }
}

