/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.crypto.Hashes;
import io.nem.symbol.core.utils.ArrayUtils;
import io.nem.symbol.core.utils.Base32Encoder;
import io.nem.symbol.core.utils.ConvertUtils;
import io.nem.symbol.sdk.model.network.NetworkType;
import java.util.Arrays;

public class RawAddress {
    public static final int NUM_CHECKSUM_BYTES = 3;

    private RawAddress() {
    }

    public static String generateAddress(String publicKey, NetworkType networkType) {
        byte[] publicKeyBytes;
        byte networkTypeValue = (byte)networkType.getValue();
        try {
            publicKeyBytes = ConvertUtils.fromHexToBytes(publicKey);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Public key is not valid");
        }
        byte[] publicKeyHash = Hashes.sha3_256(new byte[][]{publicKeyBytes});
        byte[] ripemd160StepOneHash = Hashes.ripemd160(new byte[][]{publicKeyHash});
        byte[] versionPrefixedRipemd160Hash = ArrayUtils.concat({networkTypeValue}, ripemd160StepOneHash);
        byte[] stepThreeChecksum = RawAddress.generateChecksum(versionPrefixedRipemd160Hash);
        byte[] concatStepThreeAndStepSix = ArrayUtils.concat(versionPrefixedRipemd160Hash, stepThreeChecksum);
        String base32 = Base32Encoder.getString(concatStepThreeAndStepSix);
        return base32.substring(0, base32.length() - 1);
    }

    private static byte[] generateChecksum(byte[] input) {
        byte[] stepThreeHash = Hashes.sha3_256(new byte[][]{input});
        return Arrays.copyOfRange(stepThreeHash, 0, 3);
    }
}

