/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.crypto.Key;
import io.nem.symbol.sdk.infrastructure.RandomUtils;
import java.math.BigInteger;

public class PrivateKey
extends Key {
    public static final int SIZE = 32;

    public PrivateKey(BigInteger value) {
        super(value, 32);
    }

    public PrivateKey(byte[] bytes) {
        super(bytes, 32);
    }

    public PrivateKey(String hex) {
        super(hex, 32);
    }

    public static PrivateKey fromHexString(String hex) {
        return new PrivateKey(hex);
    }

    public static PrivateKey fromDecimalString(String decimal) {
        return new PrivateKey(new BigInteger(decimal, 10));
    }

    public static PrivateKey generateRandom() {
        return new PrivateKey(RandomUtils.generateRandomBytes(32));
    }
}

