/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.crypto.Hasher;
import io.nem.symbol.core.crypto.Hashes;
import java.util.ArrayList;

public class MerkleHashBuilder {
    private final ArrayList<byte[]> hashes = new ArrayList();

    private byte[] getRootHash(ArrayList<byte[]> hashes) {
        if (hashes.isEmpty()) {
            return new byte[32];
        }
        Hasher hasher = Hashes::sha3_256;
        for (int numRemainingHashes = hashes.size(); numRemainingHashes > 1; numRemainingHashes /= 2) {
            for (int i = 0; i < numRemainingHashes; i += 2) {
                if (i + 1 < numRemainingHashes) {
                    hashes.set(i / 2, hasher.hash(hashes.get(i), hashes.get(i + 1)));
                    continue;
                }
                hashes.set(i / 2, hasher.hash(hashes.get(i), hashes.get(i)));
                ++numRemainingHashes;
            }
        }
        return hashes.get(0);
    }

    public byte[] getRootHash() {
        return this.getRootHash(this.hashes);
    }

    public void update(byte[] hash) {
        this.hashes.add(hash);
    }
}

