/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.crypto.CryptoEngine;
import io.nem.symbol.core.crypto.CryptoEngines;
import io.nem.symbol.core.crypto.PrivateKey;
import io.nem.symbol.core.crypto.PublicKey;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class KeyPair {
    private final Optional<PrivateKey> privateKey;
    private final PublicKey publicKey;

    private KeyPair(Optional<PrivateKey> privateKey, PublicKey publicKey, CryptoEngine engine) {
        Validate.notNull(privateKey, (String)"Optional PrivateKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)publicKey, (String)"PublicKey must not be null", (Object[])new Object[0]);
        if (!engine.createKeyAnalyzer().isKeyCompressed(publicKey)) {
            throw new IllegalArgumentException("PublicKey must be in compressed form");
        }
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static KeyPair random() {
        return CryptoEngines.defaultEngine().createKeyGenerator().generateKeyPair();
    }

    public static KeyPair random(CryptoEngine engine) {
        return engine.createKeyGenerator().generateKeyPair();
    }

    public static KeyPair fromPrivate(PrivateKey privateKey, CryptoEngine engine) {
        PublicKey publicKey = engine.createKeyGenerator().derivePublicKey(privateKey);
        return new KeyPair(Optional.of(privateKey), publicKey, engine);
    }

    public static KeyPair onlyPublic(PublicKey publicKey) {
        return new KeyPair(Optional.empty(), publicKey, CryptoEngines.defaultEngine());
    }

    public static KeyPair onlyPublic(PublicKey publicKey, CryptoEngine engine) {
        return new KeyPair(Optional.empty(), publicKey, engine);
    }

    public static KeyPair fromPrivate(PrivateKey privateKey) {
        return KeyPair.fromPrivate(privateKey, CryptoEngines.defaultEngine());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey.orElseThrow(() -> new IllegalStateException("Private Key hasn't been provided."));
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean hasPrivateKey() {
        return this.privateKey.isPresent();
    }
}

