/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.utils.ByteUtils;
import io.nem.symbol.core.utils.ConvertUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.Validate;

public class Key {
    private final byte[] value;

    public Key(byte[] bytes, int expectedSize) {
        Validate.notNull((Object)bytes, (String)"bytes must not be null", (Object[])new Object[0]);
        Validate.isTrue((bytes.length == expectedSize ? 1 : 0) != 0, (String)("Bytes Array size " + bytes.length + " is not " + expectedSize), (Object[])new Object[0]);
        this.value = bytes;
    }

    public Key(BigInteger value, int expectedSize) {
        this(ByteUtils.bigIntToByteArrayLeadingZeros(value, expectedSize), expectedSize);
    }

    public Key(String hex, int expectedSize) {
        this(ByteUtils.byteArrayLeadingZeros(ConvertUtils.getBytes(hex), expectedSize), expectedSize);
    }

    public int getSize() {
        return this.value.length;
    }

    public byte[] getBytes() {
        return this.value;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.value);
    }

    public BigInteger getRaw() {
        return new BigInteger(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key publicKey = (Key)o;
        return Arrays.equals(this.value, publicKey.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toHex() {
        return ConvertUtils.toHex(this.value).toUpperCase();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toHex() + '}';
    }
}

