/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.core.crypto;

import io.nem.symbol.core.crypto.CryptoException;
import io.nem.symbol.core.utils.ExceptionUtils;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Hashes {
    private static final String BC = "BC";
    private static final String SHA_256 = "SHA256";
    private static final String SHA_512 = "SHA512";
    private static final String RIPEMD_160 = "RIPEMD160";
    private static final String SHA_3_256 = "SHA3-256";
    private static final String SHA_3_512 = "SHA3-512";
    private static final String KECCAK_256 = "KECCAK-256";
    private static final String KECCAK_512 = "KECCAK-512";

    private Hashes() {
    }

    public static byte[] sha3_256(byte[] ... inputs) {
        return Hashes.hash(SHA_3_256, inputs);
    }

    public static byte[] sha3_512(byte[] ... inputs) {
        return Hashes.hash(SHA_3_512, inputs);
    }

    public static byte[] ripemd160(byte[] ... inputs) {
        return Hashes.hash(RIPEMD_160, inputs);
    }

    public static byte[] keccak256(byte[] ... inputs) {
        return Hashes.hash(KECCAK_256, inputs);
    }

    public static byte[] keccak512(byte[] ... inputs) {
        return Hashes.hash(KECCAK_512, inputs);
    }

    public static byte[] sha512(byte[] ... inputs) {
        return Hashes.hash(SHA_512, inputs);
    }

    public static byte[] hash256(byte[] ... inputs) {
        byte[] hashedSha256 = Hashes.hash(SHA_256, inputs);
        return Hashes.hash(SHA_256, new byte[][]{hashedSha256});
    }

    public static byte[] hash160(byte[] ... inputs) {
        byte[] hashedSha256 = Hashes.hash(SHA_256, inputs);
        return Hashes.hash(RIPEMD_160, new byte[][]{hashedSha256});
    }

    private static byte[] hash(String algorithm, byte[] ... inputs) {
        return ExceptionUtils.propagate(() -> {
            MessageDigest digest = MessageDigest.getInstance(algorithm, BC);
            for (byte[] input : inputs) {
                digest.update(input);
            }
            return digest.digest();
        }, e -> new CryptoException(e.getMessage(), (Throwable)e));
    }

    public static byte[] sha256ForSharedKey(byte[] sharedSecret) {
        SHA256Digest hash = new SHA256Digest();
        byte[] info = "catapult".getBytes();
        int length = 32;
        byte[] sharedKey = new byte[length];
        HKDFParameters params = new HKDFParameters(sharedSecret, null, info);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)hash);
        hkdf.init((DerivationParameters)params);
        hkdf.generateBytes(sharedKey, 0, length);
        return sharedKey;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

