/*
 * Copyright 2020 NEM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.nem.symbol.sdk.model.account;
/** Public keys the account could be associated with. */
public class AccountKey {

  /** The key type. */
  private final AccountKeyType keyType;

  /** The public key in hex. */
  private final String key;

  public AccountKey(AccountKeyType accountKeyType, String key) {
    this.keyType = accountKeyType;
    this.key = key;
  }

  public AccountKeyType getKeyType() {
    return keyType;
  }

  public String getKey() {
    return key;
  }
}
