/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest
 *
 * The version of the OpenAPI document: 1.0.3
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.LinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.VotingKeyLinkTransactionBodyDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to associate a BLS public key with an account. Required for node operators willing to vote finalized blocks. 
 */
@ApiModel(description = "Transaction to associate a BLS public key with an account. Required for node operators willing to vote finalized blocks. ")
@JsonPropertyOrder({
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_SIZE,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_SIGNATURE,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_VERSION,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_NETWORK,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_TYPE,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_MAX_FEE,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_DEADLINE,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_LINKED_PUBLIC_KEY,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_START_EPOCH,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_END_EPOCH,
  VotingKeyLinkTransactionDTO.JSON_PROPERTY_LINK_ACTION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-11-12T11:59:12.877Z[UTC]")
public class VotingKeyLinkTransactionDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_LINKED_PUBLIC_KEY = "linkedPublicKey";
  private String linkedPublicKey;

  public static final String JSON_PROPERTY_START_EPOCH = "startEpoch";
  private Long startEpoch;

  public static final String JSON_PROPERTY_END_EPOCH = "endEpoch";
  private Long endEpoch;

  public static final String JSON_PROPERTY_LINK_ACTION = "linkAction";
  private LinkActionEnum linkAction;


  public VotingKeyLinkTransactionDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public VotingKeyLinkTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public VotingKeyLinkTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public VotingKeyLinkTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public VotingKeyLinkTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public VotingKeyLinkTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public VotingKeyLinkTransactionDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public VotingKeyLinkTransactionDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public VotingKeyLinkTransactionDTO linkedPublicKey(String linkedPublicKey) {
    
    this.linkedPublicKey = linkedPublicKey;
    return this;
  }

   /**
   * 32 bytes voting public key.
   * @return linkedPublicKey
  **/
  @ApiModelProperty(example = "4EDDA97C991A0BF44E0570B0BA0E0F7F1CE821A799726888734F28DDCCE8C591", required = true, value = "32 bytes voting public key.")
  @JsonProperty(JSON_PROPERTY_LINKED_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLinkedPublicKey() {
    return linkedPublicKey;
  }


  public void setLinkedPublicKey(String linkedPublicKey) {
    this.linkedPublicKey = linkedPublicKey;
  }


  public VotingKeyLinkTransactionDTO startEpoch(Long startEpoch) {
    
    this.startEpoch = startEpoch;
    return this;
  }

   /**
   * Finalization Epoch
   * @return startEpoch
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Finalization Epoch")
  @JsonProperty(JSON_PROPERTY_START_EPOCH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getStartEpoch() {
    return startEpoch;
  }


  public void setStartEpoch(Long startEpoch) {
    this.startEpoch = startEpoch;
  }


  public VotingKeyLinkTransactionDTO endEpoch(Long endEpoch) {
    
    this.endEpoch = endEpoch;
    return this;
  }

   /**
   * Finalization Epoch
   * @return endEpoch
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Finalization Epoch")
  @JsonProperty(JSON_PROPERTY_END_EPOCH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getEndEpoch() {
    return endEpoch;
  }


  public void setEndEpoch(Long endEpoch) {
    this.endEpoch = endEpoch;
  }


  public VotingKeyLinkTransactionDTO linkAction(LinkActionEnum linkAction) {
    
    this.linkAction = linkAction;
    return this;
  }

   /**
   * Get linkAction
   * @return linkAction
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LINK_ACTION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LinkActionEnum getLinkAction() {
    return linkAction;
  }


  public void setLinkAction(LinkActionEnum linkAction) {
    this.linkAction = linkAction;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VotingKeyLinkTransactionDTO votingKeyLinkTransactionDTO = (VotingKeyLinkTransactionDTO) o;
    return Objects.equals(this.size, votingKeyLinkTransactionDTO.size) &&
        Objects.equals(this.signature, votingKeyLinkTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, votingKeyLinkTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, votingKeyLinkTransactionDTO.version) &&
        Objects.equals(this.network, votingKeyLinkTransactionDTO.network) &&
        Objects.equals(this.type, votingKeyLinkTransactionDTO.type) &&
        Objects.equals(this.maxFee, votingKeyLinkTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, votingKeyLinkTransactionDTO.deadline) &&
        Objects.equals(this.linkedPublicKey, votingKeyLinkTransactionDTO.linkedPublicKey) &&
        Objects.equals(this.startEpoch, votingKeyLinkTransactionDTO.startEpoch) &&
        Objects.equals(this.endEpoch, votingKeyLinkTransactionDTO.endEpoch) &&
        Objects.equals(this.linkAction, votingKeyLinkTransactionDTO.linkAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, maxFee, deadline, linkedPublicKey, startEpoch, endEpoch, linkAction);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VotingKeyLinkTransactionDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    linkedPublicKey: ").append(toIndentedString(linkedPublicKey)).append("\n");
    sb.append("    startEpoch: ").append(toIndentedString(startEpoch)).append("\n");
    sb.append("    endEpoch: ").append(toIndentedString(endEpoch)).append("\n");
    sb.append("    linkAction: ").append(toIndentedString(linkAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

