package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.HashLockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HashLockPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleStateInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-11-12T11:59:12.877Z[UTC]")
public class HashLockRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi delegate;

	public HashLockRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get hash lock information
     * Gets the hash lock for a given hash.
     * @param hash Filter by hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getHashLock(String hash, Handler<AsyncResult<HashLockInfoDTO>> resultHandler) {
        delegate.getHashLock(hash, resultHandler);
    }

    /**
     * Get hash lock information
     * Gets the hash lock for a given hash.
     * @param hash Filter by hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<HashLockInfoDTO> rxGetHashLock(String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getHashLock(hash, fut);
        }));
    }
    /**
     * Get hash lock merkle information
     * Gets the hash lock merkle for a given hash.
     * @param hash Filter by hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getHashLockMerkle(String hash, Handler<AsyncResult<MerkleStateInfoDTO>> resultHandler) {
        delegate.getHashLockMerkle(hash, resultHandler);
    }

    /**
     * Get hash lock merkle information
     * Gets the hash lock merkle for a given hash.
     * @param hash Filter by hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleStateInfoDTO> rxGetHashLockMerkle(String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getHashLockMerkle(hash, fut);
        }));
    }
    /**
     * Search hash lock entries
     * Returns an array of hash locks.
     * @param address Filter by address involved in the transaction. An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchHashLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<HashLockPage>> resultHandler) {
        delegate.searchHashLock(address, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Search hash lock entries
     * Returns an array of hash locks.
     * @param address Filter by address involved in the transaction. An account&#39;s address is considered to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<HashLockPage> rxSearchHashLock(String address, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchHashLock(address, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static HashLockRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.HashLockRoutesApi arg) {
        return arg != null ? new HashLockRoutesApi(arg) : null;
    }
}
