package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.FinalizationProofDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-11-12T11:59:12.877Z[UTC]")
public class FinalizationRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApi delegate;

	public FinalizationRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get finalization proof
     * Gets finalization proof for the greatest height associated with the given epoch.
     * @param epoch Finalization epoch. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getFinalizationProofAtEpoch(Long epoch, Handler<AsyncResult<FinalizationProofDTO>> resultHandler) {
        delegate.getFinalizationProofAtEpoch(epoch, resultHandler);
    }

    /**
     * Get finalization proof
     * Gets finalization proof for the greatest height associated with the given epoch.
     * @param epoch Finalization epoch. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<FinalizationProofDTO> rxGetFinalizationProofAtEpoch(Long epoch) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getFinalizationProofAtEpoch(epoch, fut);
        }));
    }
    /**
     * Get finalization proof
     * Gets finalization proof at the given height.
     * @param height Block height. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getFinalizationProofAtHeight(java.math.BigInteger height, Handler<AsyncResult<FinalizationProofDTO>> resultHandler) {
        delegate.getFinalizationProofAtHeight(height, resultHandler);
    }

    /**
     * Get finalization proof
     * Gets finalization proof at the given height.
     * @param height Block height. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<FinalizationProofDTO> rxGetFinalizationProofAtHeight(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getFinalizationProofAtHeight(height, fut);
        }));
    }

    public static FinalizationRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.FinalizationRoutesApi arg) {
        return arg != null ? new FinalizationRoutesApi(arg) : null;
    }
}
