package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.BlockPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface BlockRoutesApi {

    void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> handler);

    void getMerkleReceipts(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> handler);

    void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> handler);

    void searchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy, Handler<AsyncResult<BlockPage>> handler);

}
