/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.ProofGammaDto;
import io.nem.symbol.catapult.builders.ProofScalarDto;
import io.nem.symbol.catapult.builders.ProofVerificationHashDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class VrfProofBuilder
implements Serializer {
    private final ProofGammaDto gamma;
    private final ProofVerificationHashDto verificationHash;
    private final ProofScalarDto scalar;

    protected VrfProofBuilder(DataInputStream stream) {
        try {
            this.gamma = ProofGammaDto.loadFromBinary(stream);
            this.verificationHash = ProofVerificationHashDto.loadFromBinary(stream);
            this.scalar = ProofScalarDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static VrfProofBuilder loadFromBinary(DataInputStream stream) {
        return new VrfProofBuilder(stream);
    }

    protected VrfProofBuilder(ProofGammaDto gamma, ProofVerificationHashDto verificationHash, ProofScalarDto scalar) {
        GeneratorUtils.notNull(gamma, "gamma is null", new Object[0]);
        GeneratorUtils.notNull(verificationHash, "verificationHash is null", new Object[0]);
        GeneratorUtils.notNull(scalar, "scalar is null", new Object[0]);
        this.gamma = gamma;
        this.verificationHash = verificationHash;
        this.scalar = scalar;
    }

    public static VrfProofBuilder create(ProofGammaDto gamma, ProofVerificationHashDto verificationHash, ProofScalarDto scalar) {
        return new VrfProofBuilder(gamma, verificationHash, scalar);
    }

    public ProofGammaDto getGamma() {
        return this.gamma;
    }

    public ProofVerificationHashDto getVerificationHash() {
        return this.verificationHash;
    }

    public ProofScalarDto getScalar() {
        return this.scalar;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.gamma.getSize();
        size += this.verificationHash.getSize();
        return size += this.scalar.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.gamma);
            GeneratorUtils.writeEntity(dataOutputStream, this.verificationHash);
            GeneratorUtils.writeEntity(dataOutputStream, this.scalar);
        });
    }
}

