/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class VotingKeyDto
implements Serializer {
    private final ByteBuffer votingKey;

    public VotingKeyDto(ByteBuffer votingKey) {
        this.votingKey = votingKey;
    }

    public VotingKeyDto(DataInputStream stream) {
        try {
            this.votingKey = GeneratorUtils.readByteBuffer(stream, 32);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getVotingKey() {
        return this.votingKey;
    }

    @Override
    public int getSize() {
        return 32;
    }

    public static VotingKeyDto loadFromBinary(DataInputStream stream) {
        return new VotingKeyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.votingKey.array(), 0, this.votingKey.array().length));
    }
}

